/*
 * Decompiled with CFR 0.152.
 */
package event.logging.impl;

import event.logging.Event;
import event.logging.EventLoggerBuilder;
import event.logging.EventLoggingService;
import event.logging.XMLValidator;
import event.logging.impl.DefaultEventSerializer;
import event.logging.impl.DefaultXMLValidator;
import event.logging.impl.EventLoggerBuilderImpl;
import event.logging.impl.EventSerializer;
import event.logging.impl.LogReceiver;
import event.logging.impl.LogReceiverFactory;
import event.logging.impl.SchemaLocator;
import event.logging.impl.ValidationExceptionBehaviourMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;

public class DefaultEventLoggingService
implements EventLoggingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEventLoggingService.class);
    private static final String SCHEMA_LOCATION = SchemaLocator.getSchemaLocation();
    private static final String VALIDATE = "event.logging.validate";
    private final EventSerializer eventSerializer = new DefaultEventSerializer();
    private final LogReceiverFactory logReceiverFactory = LogReceiverFactory.getInstance();
    private final XMLValidator xmlValidator;
    private Boolean validate;

    public DefaultEventLoggingService() {
        this.xmlValidator = new DefaultXMLValidator(SCHEMA_LOCATION);
    }

    public DefaultEventLoggingService(ErrorHandler schemaValidationErrorHandler) {
        this.xmlValidator = new DefaultXMLValidator(SCHEMA_LOCATION, schemaValidationErrorHandler);
    }

    public DefaultEventLoggingService(ErrorHandler schemaValidationErrorHandler, ValidationExceptionBehaviourMode validationExceptionBehaviourMode) {
        LOGGER.info("Using schema location " + SCHEMA_LOCATION);
        this.xmlValidator = new DefaultXMLValidator(SCHEMA_LOCATION, schemaValidationErrorHandler, validationExceptionBehaviourMode);
    }

    @Override
    public void log(Event event) {
        String data = this.eventSerializer.serialize(event);
        String trimmed = data.trim();
        if (trimmed.length() > 0) {
            if (this.checkValidating()) {
                this.xmlValidator.validate(trimmed);
            }
            LogReceiver logReceiver = this.logReceiverFactory.getLogReceiver();
            logReceiver.log(trimmed);
        }
    }

    @Override
    public EventLoggerBuilder.TypeIdStep loggedWorkBuilder() {
        return new EventLoggerBuilderImpl(this);
    }

    private boolean checkValidating() {
        if (this.validate != null) {
            return this.validate;
        }
        String val = System.getProperty(VALIDATE);
        return Boolean.valueOf(val);
    }

    @Override
    public void setValidate(Boolean validate) {
        this.validate = validate;
    }

    @Override
    public boolean isValidate() {
        return this.validate != null && this.validate != false;
    }
}

