/*
 * Decompiled with CFR 0.152.
 */
package event.logging.impl;

import event.logging.XMLValidator;
import event.logging.impl.LoggingErrorHandler;
import event.logging.impl.ValidationExceptionBehaviourMode;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class DefaultXMLValidator
implements XMLValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultXMLValidator.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final String XML11_PI = "<?xml version=\"1.1\" encoding=\"UTF-8\"?>\n";
    private static boolean xml11 = true;
    private final Schema schema;
    private final ErrorHandler validationErrorHandler;
    private static final ValidationExceptionBehaviourMode DEFAULT_VALIDATION_EXCEPTION_BEHAVIOUR_MODE = ValidationExceptionBehaviourMode.LOG;
    private final ValidationExceptionBehaviourMode validationExceptionBehaviourMode;

    public DefaultXMLValidator(String schemaLocation) {
        this(schemaLocation, new LoggingErrorHandler(), DEFAULT_VALIDATION_EXCEPTION_BEHAVIOUR_MODE);
    }

    public DefaultXMLValidator(String schemaLocation, ErrorHandler validationErrorHandler) {
        this(schemaLocation, validationErrorHandler, DEFAULT_VALIDATION_EXCEPTION_BEHAVIOUR_MODE);
    }

    public DefaultXMLValidator(String schemaLocation, ErrorHandler validationErrorHandler, ValidationExceptionBehaviourMode validationExceptionBehaviourMode) {
        if (validationErrorHandler == null) {
            throw new RuntimeException("Null errorHandler supplied");
        }
        this.schema = this.loadSchema(schemaLocation);
        this.validationErrorHandler = validationErrorHandler;
        this.validationExceptionBehaviourMode = validationExceptionBehaviourMode;
    }

    private Schema loadSchema(String schemaLocation) {
        Schema schema = null;
        try {
            if (schemaLocation == null) {
                throw new NullPointerException("You must specify a schema location");
            }
            InputStream inputStream = this.getClass().getResourceAsStream(schemaLocation);
            if (inputStream == null) {
                throw new FileNotFoundException("Unable to locate schema on classpath: " + schemaLocation);
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            LoggingErrorHandler errorHandler = new LoggingErrorHandler();
            schemaFactory.setErrorHandler(errorHandler);
            schema = schemaFactory.newSchema(new StreamSource(inputStream));
            if (!errorHandler.isOk()) {
                schema = null;
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return schema;
    }

    @Override
    public void validate(String xml) {
        if (this.validationExceptionBehaviourMode.equals((Object)ValidationExceptionBehaviourMode.LOG)) {
            this.validateAndLog(xml);
        } else {
            this.validateAndThrow(xml);
        }
    }

    private void validateAndThrow(String xml) {
        if (this.schema != null) {
            try {
                this.doValidation(xml);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while validating against the schema", e);
            }
        } else {
            throw new RuntimeException("Unable to validate.  Schema object is null");
        }
    }

    private void validateAndLog(String xml) {
        if (this.schema != null) {
            try {
                this.doValidation(xml);
            }
            catch (IOException | SAXException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private synchronized void doValidation(String xml) throws SAXException, IOException {
        if (this.schema != null) {
            byte[] bytes = null;
            bytes = xml11 ? (XML11_PI + xml).getBytes(DEFAULT_CHARSET) : xml.getBytes(DEFAULT_CHARSET);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            Validator validator = this.schema.newValidator();
            validator.setErrorHandler(this.validationErrorHandler);
            StreamSource streamSource = new StreamSource(inputStream);
            validator.validate(streamSource);
        }
    }
}

