/*
 * Decompiled with CFR 0.152.
 */
package event.logging.impl;

import event.logging.BaseOutcome;
import event.logging.ComplexLoggedOutcome;
import event.logging.Event;
import event.logging.EventAction;
import event.logging.EventLoggerBuilder;
import event.logging.EventLoggingService;
import event.logging.HasOutcome;
import event.logging.LoggedWorkExceptionHandler;
import event.logging.Purpose;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLoggerBuilderImpl<T_EVENT_ACTION extends EventAction>
implements EventLoggerBuilder.TypeIdStep,
EventLoggerBuilder.DescriptionStep,
EventLoggerBuilder.EventActionStep,
EventLoggerBuilder.WorkStep<T_EVENT_ACTION> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventLoggerBuilderImpl.class);
    private static final Map<Class<? extends EventAction>, Optional<Function<EventAction, BaseOutcome>>> OUTCOME_FACTORY_MAP = new ConcurrentHashMap<Class<? extends EventAction>, Optional<Function<EventAction, BaseOutcome>>>();
    private final EventLoggingService eventLoggingService;
    private String eventTypeId;
    private String description;
    private T_EVENT_ACTION eventAction;
    private Purpose purpose;
    private boolean isLogEventRequired = true;
    private LoggedWorkExceptionHandler<T_EVENT_ACTION> exceptionHandler;

    EventLoggerBuilderImpl(EventLoggingService eventLoggingService) {
        this.eventLoggingService = eventLoggingService;
    }

    @Override
    public EventLoggerBuilder.DescriptionStep withTypeId(String typeId) {
        this.eventTypeId = typeId;
        return this;
    }

    String getTypeId() {
        return this.eventTypeId;
    }

    @Override
    public EventLoggerBuilder.EventActionStep withDescription(String description) {
        this.description = description;
        return this;
    }

    String getDescription() {
        return this.description;
    }

    @Override
    public <T extends EventAction> EventLoggerBuilder.WorkStep<T> withDefaultEventAction(T defaultEventAction) {
        this.eventAction = defaultEventAction;
        return this;
    }

    T_EVENT_ACTION getEventAction() {
        return this.eventAction;
    }

    @Override
    public <T_RESULT> EventLoggerBuilder.ResultSubBuilder<T_EVENT_ACTION, T_RESULT> withComplexLoggedResult(Function<T_EVENT_ACTION, ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION>> loggedWork) {
        return new ResultSubBuilderImpl<T_EVENT_ACTION, T_RESULT>(this, Objects.requireNonNull(loggedWork, "loggedWork must be provided"));
    }

    @Override
    public <T_RESULT> EventLoggerBuilder.ResultSubBuilder<T_EVENT_ACTION, T_RESULT> withSimpleLoggedResult(Supplier<T_RESULT> loggedWork) {
        return new ResultSubBuilderImpl(this, eventAction -> ComplexLoggedOutcome.success(Objects.requireNonNull(loggedWork, "loggedWork must be provided").get(), eventAction));
    }

    @Override
    public EventLoggerBuilder.ActionSubBuilder<T_EVENT_ACTION> withComplexLoggedAction(Function<T_EVENT_ACTION, ComplexLoggedOutcome<Void, T_EVENT_ACTION>> loggedAction) {
        return new ActionSubBuilderImpl<T_EVENT_ACTION>(this, Objects.requireNonNull(loggedAction, "loggedAction must be provided"));
    }

    @Override
    public EventLoggerBuilder.ActionSubBuilder<T_EVENT_ACTION> withSimpleLoggedAction(Runnable loggedAction) {
        return new ActionSubBuilderImpl<EventAction>(this, eventAction -> {
            loggedAction.run();
            return ComplexLoggedOutcome.success(eventAction);
        });
    }

    private <T_RESULT> T_RESULT loggedResult(String eventTypeId, String description, Purpose purpose, T_EVENT_ACTION eventAction, Function<T_EVENT_ACTION, ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION>> loggedWork, LoggedWorkExceptionHandler<T_EVENT_ACTION> exceptionHandler, boolean isLoggingRequired) {
        T_RESULT result;
        Objects.requireNonNull(eventAction);
        Objects.requireNonNull(loggedWork);
        if (isLoggingRequired) {
            try {
                ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION> complexLoggedOutcome = loggedWork.apply(eventAction);
                Event event = this.eventLoggingService.createEvent(eventTypeId, description, purpose, (EventAction)complexLoggedOutcome.getEventAction());
                if (!complexLoggedOutcome.wasSuccessful() && eventAction instanceof HasOutcome) {
                    this.addFailureOutcome(complexLoggedOutcome.getOutcomeDescription(), (EventAction)complexLoggedOutcome.getEventAction());
                }
                this.eventLoggingService.log(event);
                result = complexLoggedOutcome.getResult();
            }
            catch (Throwable e) {
                T_EVENT_ACTION newEventAction = eventAction;
                if (exceptionHandler != null) {
                    try {
                        newEventAction = exceptionHandler.handle(eventAction, e);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error running exception handler. Swallowing exception and rethrowing original exception", e);
                    }
                } else if (eventAction instanceof HasOutcome) {
                    this.addFailureOutcome(e, (EventAction)newEventAction);
                }
                Event event = this.eventLoggingService.createEvent(eventTypeId, description, (EventAction)newEventAction);
                this.eventLoggingService.log(event);
                throw e;
            }
        } else {
            result = loggedWork.apply(eventAction).getResult();
        }
        return result;
    }

    private void addFailureOutcome(Throwable e, EventAction eventAction) {
        String description = e.getMessage() != null ? e.getMessage() : e.getClass().getName();
        this.addFailureOutcome(description, eventAction);
    }

    private void addFailureOutcome(String description, EventAction eventAction) {
        try {
            HasOutcome hasOutcome = (HasOutcome)((Object)eventAction);
            BaseOutcome baseOutcome = hasOutcome.getOutcome();
            if (baseOutcome == null) {
                baseOutcome = this.createBaseOutcome(eventAction).orElse(null);
            }
            if (baseOutcome == null) {
                LOGGER.error("Unable to set outcome on {}", (Object)eventAction.getClass().getName());
            } else {
                baseOutcome.setSuccess(false);
                baseOutcome.setDescription(description);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to add failure outcome to {}", (Object)eventAction.getClass().getName(), (Object)e);
        }
    }

    private Optional<BaseOutcome> createBaseOutcome(EventAction eventAction) {
        return OUTCOME_FACTORY_MAP.computeIfAbsent(eventAction.getClass(), clazz -> Arrays.stream(eventAction.getClass().getMethods()).filter(outcomeSetter -> outcomeSetter.getName().equals("setOutcome")).findAny().flatMap(outcomeSetter -> {
            Constructor<?> constructor;
            Class<?> outcomeClass = outcomeSetter.getParameterTypes()[0];
            try {
                constructor = outcomeClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("No noargs constructor found for " + outcomeClass.getName(), (Throwable)e);
                return Optional.empty();
            }
            Function<EventAction, BaseOutcome> outcomeAdderFunc = anEventAction -> {
                try {
                    BaseOutcome outcome = (BaseOutcome)constructor.newInstance(new Object[0]);
                    outcomeSetter.invoke(anEventAction, outcomeClass.cast(outcome));
                    return outcome;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            LOGGER.debug("Caching function for {}", (Object)eventAction.getClass().getName());
            return Optional.of(outcomeAdderFunc);
        })).flatMap(outcomeSetter -> Optional.of(outcomeSetter.apply(eventAction)));
    }

    public static class ActionSubBuilderImpl<T_EVENT_ACTION extends EventAction>
    implements EventLoggerBuilder.ActionSubBuilder<T_EVENT_ACTION> {
        private final EventLoggerBuilderImpl<T_EVENT_ACTION> basicBuilder;
        private final Function<T_EVENT_ACTION, ComplexLoggedOutcome<Void, T_EVENT_ACTION>> loggedAction;

        ActionSubBuilderImpl(EventLoggerBuilderImpl<T_EVENT_ACTION> basicBuilder, Function<T_EVENT_ACTION, ComplexLoggedOutcome<Void, T_EVENT_ACTION>> loggedAction) {
            this.basicBuilder = basicBuilder;
            this.loggedAction = loggedAction;
        }

        Function<T_EVENT_ACTION, ComplexLoggedOutcome<Void, T_EVENT_ACTION>> getLoggedAction() {
            return this.loggedAction;
        }

        @Override
        public EventLoggerBuilder.ActionSubBuilder<T_EVENT_ACTION> withCustomExceptionHandler(LoggedWorkExceptionHandler<T_EVENT_ACTION> exceptionHandler) {
            ((EventLoggerBuilderImpl)this.basicBuilder).exceptionHandler = exceptionHandler;
            return this;
        }

        @Override
        public EventLoggerBuilder.ActionSubBuilder<T_EVENT_ACTION> withPurpose(Purpose purpose) {
            ((EventLoggerBuilderImpl)this.basicBuilder).purpose = purpose;
            return this;
        }

        @Override
        public EventLoggerBuilder.ActionSubBuilder<T_EVENT_ACTION> withLoggingRequiredWhen(boolean isLoggingRequired) {
            ((EventLoggerBuilderImpl)this.basicBuilder).isLogEventRequired = isLoggingRequired;
            return this;
        }

        @Override
        public void runActionAndLog() {
            ((EventLoggerBuilderImpl)this.basicBuilder).loggedResult(((EventLoggerBuilderImpl)this.basicBuilder).eventTypeId, ((EventLoggerBuilderImpl)this.basicBuilder).description, ((EventLoggerBuilderImpl)this.basicBuilder).purpose, ((EventLoggerBuilderImpl)this.basicBuilder).eventAction, this.loggedAction::apply, ((EventLoggerBuilderImpl)this.basicBuilder).exceptionHandler, ((EventLoggerBuilderImpl)this.basicBuilder).isLogEventRequired);
        }
    }

    public static class ResultSubBuilderImpl<T_EVENT_ACTION extends EventAction, T_RESULT>
    implements EventLoggerBuilder.ResultSubBuilder<T_EVENT_ACTION, T_RESULT> {
        private final EventLoggerBuilderImpl<T_EVENT_ACTION> basicBuilder;
        private final Function<T_EVENT_ACTION, ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION>> loggedWork;

        ResultSubBuilderImpl(EventLoggerBuilderImpl<T_EVENT_ACTION> basicBuilder, Function<T_EVENT_ACTION, ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION>> loggedWork) {
            this.loggedWork = loggedWork;
            this.basicBuilder = basicBuilder;
        }

        Function<T_EVENT_ACTION, ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION>> getLoggedWork() {
            return this.loggedWork;
        }

        @Override
        public EventLoggerBuilder.ResultSubBuilder<T_EVENT_ACTION, T_RESULT> withCustomExceptionHandler(LoggedWorkExceptionHandler<T_EVENT_ACTION> exceptionHandler) {
            ((EventLoggerBuilderImpl)this.basicBuilder).exceptionHandler = exceptionHandler;
            return this;
        }

        @Override
        public EventLoggerBuilder.ResultSubBuilder<T_EVENT_ACTION, T_RESULT> withPurpose(Purpose purpose) {
            ((EventLoggerBuilderImpl)this.basicBuilder).purpose = purpose;
            return this;
        }

        @Override
        public EventLoggerBuilder.ResultSubBuilder<T_EVENT_ACTION, T_RESULT> withLoggingRequiredWhen(boolean isLoggingRequired) {
            ((EventLoggerBuilderImpl)this.basicBuilder).isLogEventRequired = isLoggingRequired;
            return this;
        }

        @Override
        public T_RESULT getResultAndLog() {
            return (T_RESULT)((EventLoggerBuilderImpl)this.basicBuilder).loggedResult(((EventLoggerBuilderImpl)this.basicBuilder).eventTypeId, ((EventLoggerBuilderImpl)this.basicBuilder).description, ((EventLoggerBuilderImpl)this.basicBuilder).purpose, ((EventLoggerBuilderImpl)this.basicBuilder).eventAction, this.loggedWork, ((EventLoggerBuilderImpl)this.basicBuilder).exceptionHandler, ((EventLoggerBuilderImpl)this.basicBuilder).isLogEventRequired);
        }
    }
}

