/*
 * Decompiled with CFR 0.152.
 */
package event.logging.impl;

import event.logging.Event;
import event.logging.EventDetail;
import event.logging.EventLoggerBuilder;
import event.logging.EventLoggingService;
import event.logging.impl.MockEventLoggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockEventLoggingService
implements EventLoggingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockEventLoggingService.class);

    @Override
    public void log(Event event) {
        if (LOGGER.isDebugEnabled()) {
            this.debugEvent(event);
        }
    }

    @Override
    public EventLoggerBuilder.TypeIdStep loggedWorkBuilder() {
        return new MockEventLoggerBuilder(this);
    }

    @Override
    public void setValidate(Boolean validate) {
    }

    @Override
    public boolean isValidate() {
        return false;
    }

    private void debugEvent(Event event) {
        String typeId = null;
        String description = null;
        String eventActionName = null;
        if (event != null && event.getEventDetail() != null) {
            EventDetail eventDetail = event.getEventDetail();
            typeId = eventDetail.getTypeId();
            description = eventDetail.getDescription();
            eventActionName = eventDetail.getEventAction().getClass().getSimpleName();
        }
        String info = String.join((CharSequence)"typeId: '", typeId, "' description: '", description, "' eventActionName: '", eventActionName);
        LOGGER.debug("log() called for event - " + info);
    }
}

