/*
 * Decompiled with CFR 0.152.
 */
package event.logging.impl;

public final class XMLUtil {
    private static final int CHAR_REF_LEN = 10;
    private static final int N0X2028 = 8232;
    private static final int N160 = 160;
    private static final int N128 = 128;
    private static final int N127 = 127;
    private static final int N32 = 32;
    private static final int N31 = 31;
    private static boolean[] specialInText;
    private static boolean[] specialInAtt;

    private XMLUtil() {
    }

    public static void escape(String value, boolean inAttribute, StringBuilder output) {
        int segstart = 0;
        boolean[] specialChars = specialInText;
        if (inAttribute) {
            specialChars = specialInAtt;
        }
        int clength = value.length();
        while (segstart < clength) {
            char c;
            int i = segstart;
            while (i < clength) {
                c = value.charAt(i);
                if (c < '\u007f') {
                    if (specialChars[c]) break;
                    ++i;
                    continue;
                }
                if (c < '\u00a0' || c == '\u2028') break;
                ++i;
            }
            if (i >= clength) {
                if (segstart == 0) {
                    output.append(value);
                } else {
                    output.append(value.subSequence(segstart, i));
                }
                return;
            }
            if (i > segstart) {
                output.append(value.subSequence(segstart, i));
            }
            if ((c = value.charAt(i)) >= '\u007f' && c < '\u00a0') {
                XMLUtil.outputCharacterReference(c, output);
            } else if (c >= '\u00a0') {
                if (c == '\u2028') {
                    XMLUtil.outputCharacterReference(c, output);
                } else {
                    XMLUtil.outputCharacterReference(c, output);
                }
            } else if (c == '<') {
                output.append("&lt;");
            } else if (c == '>') {
                output.append("&gt;");
            } else if (c == '&') {
                output.append("&amp;");
            } else if (c == '\"') {
                output.append("&#34;");
            } else if (c == '\n') {
                output.append("&#xA;");
            } else if (c == '\r') {
                output.append("&#xD;");
            } else if (c == '\t') {
                output.append("&#x9;");
            } else {
                XMLUtil.outputCharacterReference(c, output);
            }
            segstart = ++i;
        }
    }

    private static void outputCharacterReference(int charval, StringBuilder output) {
        int o = 0;
        char[] charref = new char[10];
        charref[o++] = 38;
        charref[o++] = 35;
        String code = Integer.toString(charval);
        int len = code.length();
        for (int k = 0; k < len; ++k) {
            charref[o++] = code.charAt(k);
        }
        charref[o++] = 59;
        output.append(charref, 0, o);
    }

    static {
        int i;
        specialInText = new boolean[128];
        for (i = 0; i <= 31; ++i) {
            XMLUtil.specialInText[i] = true;
        }
        for (i = 32; i <= 127; ++i) {
            XMLUtil.specialInText[i] = false;
        }
        XMLUtil.specialInText[10] = false;
        XMLUtil.specialInText[9] = false;
        XMLUtil.specialInText[13] = true;
        XMLUtil.specialInText[60] = true;
        XMLUtil.specialInText[62] = true;
        XMLUtil.specialInText[38] = true;
        specialInAtt = new boolean[128];
        for (i = 0; i <= 31; ++i) {
            XMLUtil.specialInAtt[i] = true;
        }
        for (i = 32; i <= 127; ++i) {
            XMLUtil.specialInAtt[i] = false;
        }
        XMLUtil.specialInAtt[0] = true;
        XMLUtil.specialInAtt[13] = true;
        XMLUtil.specialInAtt[10] = true;
        XMLUtil.specialInAtt[9] = true;
        XMLUtil.specialInAtt[60] = true;
        XMLUtil.specialInAtt[62] = true;
        XMLUtil.specialInAtt[38] = true;
        XMLUtil.specialInAtt[34] = true;
    }
}

