/*
 * Decompiled with CFR 0.152.
 */
package event.logging.impl;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLWriter
implements ContentHandler {
    public static final char SURROGATE1_MIN = '\ud800';
    public static final char SURROGATE1_MAX = '\udbff';
    private static final boolean[] specialInText;
    private static final boolean[] specialInAtt;
    private static final XMLVersion DEFAULT_VERSION;
    private static final int DEFAULT_INDENTATION = 2;
    private char[] indentChars = new char[]{'\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private boolean sortAtts = true;
    private boolean outputXMLDecl = false;
    private final XMLVersion version = DEFAULT_VERSION;
    private int indentation = 2;
    private boolean normalizeSpace = false;
    private final List<String> attList = new ArrayList<String>();
    private final Map<String, String> prefixMap = new HashMap<String, String>();
    private final List<String> unwrittenPrefixes = new ArrayList<String>();
    private final Writer writer;
    private final StringBuilder buf = new StringBuilder();
    private final StringWriter stringWriter = new StringWriter();
    private final AttributeNameComparator attributeNameComparator = new AttributeNameComparator();
    private boolean inStart;
    private int level;
    private int attIndent = 1;
    private boolean sameline;
    private boolean afterStartTag = false;
    private boolean afterEndTag = false;
    private boolean allWhite = true;
    private int line = 0;
    private int column = 0;

    public XMLWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            if (this.outputXMLDecl) {
                this.writer.write("<?xml version=\"" + this.version.getOutput() + "\" encoding=\"UTF-8\"?>");
                this.afterEndTag = true;
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (this.afterEndTag) {
                this.writer.write(10);
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixMap.put(prefix, uri);
        this.unwrittenPrefixes.add(prefix);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.prefixMap.remove(prefix);
        this.unwrittenPrefixes.remove(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (this.inStart) {
                this.inStart = false;
                this.writer.write(62);
            }
            this.writeCharacters(false);
            if (this.afterStartTag || this.afterEndTag) {
                this.indent();
            }
            this.writer.write(60);
            this.writer.write(qName);
            if (this.unwrittenPrefixes.size() > 0) {
                int spaces = this.indentation * this.level + qName.length() + 3;
                this.growIndentChars(spaces + 2);
                int nextAttIndent = spaces;
                Collections.sort(this.unwrittenPrefixes);
                for (String prefix : this.unwrittenPrefixes) {
                    String prefixUri = this.prefixMap.get(prefix);
                    this.buf.append("xmlns");
                    if (prefix.length() > 0) {
                        this.buf.append(":");
                        this.buf.append(prefix);
                    }
                    String attName = this.getChars();
                    this.writeAttribute(this.writer, attName, prefixUri);
                    this.attIndent = nextAttIndent;
                }
                this.unwrittenPrefixes.clear();
            }
            this.writeAtts(this.writer, atts);
            this.attIndent = 1;
            this.inStart = true;
            ++this.level;
            this.sameline = true;
            this.afterStartTag = true;
            this.afterEndTag = false;
            this.allWhite = true;
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            --this.level;
            this.writeCharacters(this.afterStartTag);
            if (this.inStart) {
                this.inStart = false;
                this.writer.write("/>");
            } else {
                if (this.afterEndTag && !this.sameline) {
                    this.indent();
                }
                this.writer.write("</");
                this.writer.write(qName);
                this.writer.write(">");
            }
            this.sameline = false;
            this.afterEndTag = true;
            this.afterStartTag = false;
            this.allWhite = true;
            this.line = 0;
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.buf.append(chars, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private void writeCharacters(boolean neverNormalize) throws SAXException {
        try {
            String string = this.getEscapedChars();
            if (this.normalizeSpace && !neverNormalize) {
                string = string.trim();
            }
            if (string.length() > 0) {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\n') {
                        this.sameline = false;
                        ++this.line;
                        this.column = 0;
                    }
                    if (!Character.isWhitespace(c)) {
                        this.allWhite = false;
                    }
                    ++this.column;
                }
                if (this.inStart) {
                    this.inStart = false;
                    this.writer.write(62);
                }
                this.writer.write(string);
                if (!this.allWhite) {
                    this.afterStartTag = false;
                    this.afterEndTag = false;
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    private void writeAtts(Writer writer, Attributes atts) throws SAXException {
        if (this.sortAtts) {
            for (int i = 0; i < atts.getLength(); ++i) {
                this.attList.add(atts.getQName(i));
            }
            Collections.sort(this.attList, this.attributeNameComparator);
            for (String qName : this.attList) {
                this.writeAttribute(writer, qName, atts.getValue(qName));
            }
            this.attList.clear();
        } else {
            for (int i = 0; i < atts.getLength(); ++i) {
                this.writeAttribute(writer, atts.getQName(i), atts.getValue(i));
            }
        }
    }

    private void writeAttribute(Writer writer, String name, String value) throws SAXException {
        try {
            if (this.attIndent > 1) {
                writer.write(this.indentChars, 0, this.attIndent);
            } else {
                writer.write(32);
            }
            writer.write(name);
            writer.write("=\"");
            this.writeEscape(writer, value, true);
            writer.write(34);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    private String getEscapedChars() throws SAXException {
        try {
            String chars = this.buf.toString();
            this.buf.setLength(0);
            this.writeEscape(this.stringWriter, chars, false);
            this.stringWriter.flush();
            chars = this.stringWriter.toString();
            this.stringWriter.getBuffer().setLength(0);
            return chars;
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    private String getChars() throws SAXException {
        String chars = this.buf.toString();
        this.buf.setLength(0);
        return chars;
    }

    private void writeEscape(Writer writer, String chars, boolean inAttribute) throws IOException, SAXException {
        int segstart = 0;
        boolean[] specialChars = inAttribute ? specialInAtt : specialInText;
        int clength = chars.length();
        while (segstart < clength) {
            char c;
            int i = segstart;
            while (i < clength) {
                c = chars.charAt(i);
                if (c < '\u007f') {
                    if (specialChars[c]) break;
                    ++i;
                    continue;
                }
                if (c < '\u00a0' || c == '\u2028' || this.isHighSurrogate(c) || c >= '\ufffe') break;
                ++i;
            }
            if (i >= clength) {
                if (segstart == 0) {
                    writer.write(chars);
                } else {
                    writer.write(chars.substring(segstart, i));
                }
                return;
            }
            if (i > segstart) {
                writer.write(chars.substring(segstart, i));
            }
            if ((c = chars.charAt(i)) != '\u0000') {
                if (c < '\u007f') {
                    if (c == '<') {
                        writer.write("&lt;");
                    } else if (c == '>') {
                        writer.write("&gt;");
                    } else if (c == '&') {
                        writer.write("&amp;");
                    } else if (c == '\"') {
                        writer.write("&#34;");
                    } else if (c == '\n') {
                        writer.write("&#xA;");
                    } else if (c == '\r') {
                        writer.write("&#xD;");
                    } else if (c == '\t') {
                        writer.write("&#x9;");
                    } else if (c <= '\u001f') {
                        if (XMLVersion.VERSION_1_1.equals((Object)this.version)) {
                            this.outputCharacterReference(writer, c);
                        }
                    } else {
                        this.outputCharacterReference(writer, c);
                    }
                } else if (c < '\u00a0' || c == '\u2028') {
                    this.outputCharacterReference(writer, c);
                } else if (this.isHighSurrogate(c)) {
                    char d = chars.charAt(++i);
                    writer.write(c);
                    writer.write(d);
                } else if (c < '\ufffe') {
                    this.outputCharacterReference(writer, c);
                }
            }
            segstart = ++i;
        }
    }

    private void outputCharacterReference(Writer writer, int charval) throws IOException {
        writer.write("&#x");
        writer.write(Integer.toHexString(charval));
        writer.write(59);
    }

    private boolean isHighSurrogate(int ch) {
        return 55296 <= ch && ch <= 56319;
    }

    private void indent() throws IOException {
        int spaces = this.level * this.indentation;
        if (this.line > 0 && (spaces -= this.column) <= 0) {
            return;
        }
        this.growIndentChars(spaces + 2);
        int start = this.line == 0 ? 0 : 1;
        this.writer.write(this.indentChars, start, spaces + 1);
        this.sameline = false;
    }

    private void growIndentChars(int len) {
        if (len >= this.indentChars.length) {
            int increment = 5 * this.indentation;
            if (len > this.indentChars.length + increment) {
                increment += len;
            }
            char[] tmp = new char[this.indentChars.length + increment];
            System.arraycopy(this.indentChars, 0, tmp, 0, this.indentChars.length);
            Arrays.fill(tmp, this.indentChars.length, tmp.length, ' ');
            this.indentChars = tmp;
        }
    }

    public void setSortAtts(boolean sortAtts) {
        this.sortAtts = sortAtts;
    }

    public void setOutputXMLDecl(boolean outputXMLDecl) {
        this.outputXMLDecl = outputXMLDecl;
    }

    public void setIndentation(int indentation) {
        this.indentation = indentation;
    }

    public void setNormalizeSpace(boolean normalizeSpace) {
        this.normalizeSpace = normalizeSpace;
    }

    static {
        int i;
        specialInText = new boolean[128];
        for (i = 0; i <= 31; ++i) {
            XMLWriter.specialInText[i] = true;
        }
        for (i = 32; i <= 127; ++i) {
            XMLWriter.specialInText[i] = false;
        }
        XMLWriter.specialInText[10] = false;
        XMLWriter.specialInText[9] = false;
        XMLWriter.specialInText[13] = true;
        XMLWriter.specialInText[60] = true;
        XMLWriter.specialInText[62] = true;
        XMLWriter.specialInText[38] = true;
        specialInAtt = new boolean[128];
        for (i = 0; i <= 31; ++i) {
            XMLWriter.specialInAtt[i] = true;
        }
        for (i = 32; i <= 127; ++i) {
            XMLWriter.specialInAtt[i] = false;
        }
        XMLWriter.specialInAtt[0] = true;
        XMLWriter.specialInAtt[13] = true;
        XMLWriter.specialInAtt[10] = true;
        XMLWriter.specialInAtt[9] = true;
        XMLWriter.specialInAtt[60] = true;
        XMLWriter.specialInAtt[62] = true;
        XMLWriter.specialInAtt[38] = true;
        XMLWriter.specialInAtt[34] = true;
        DEFAULT_VERSION = XMLVersion.VERSION_1_1;
    }

    private static class AttributeNameComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = -9219753718768871842L;

        private AttributeNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.startsWith("xsi:") && o2.startsWith("xsi:")) {
                return o1.compareTo(o2);
            }
            if (o1.startsWith("xsi:")) {
                return -1;
            }
            if (o2.startsWith("xsi:")) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    public static enum XMLVersion {
        VERSION_1_0("1.0"),
        VERSION_1_1("1.1");

        private final String output;

        private XMLVersion(String output) {
            this.output = output;
        }

        public String getOutput() {
            return this.output;
        }
    }
}

