/*
 * Decompiled with CFR 0.152.
 */
package event.logging.util;

import event.logging.AuthenticateAction;
import event.logging.AuthenticateEventAction;
import event.logging.AuthenticateOutcome;
import event.logging.AuthenticateOutcomeReason;
import event.logging.Event;
import event.logging.EventDetail;
import event.logging.util.EventLoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthenticateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticateUtil.class);
    private static final String LOGON = "Logon";
    private static final String LOGOFF = "Logoff";

    private AuthenticateUtil() {
    }

    public static void logon(Event event, String userId, Boolean successful, Boolean interactive, AuthenticateOutcomeReason reason) {
        try {
            AuthenticateEventAction authenticateEvent = new AuthenticateEventAction();
            authenticateEvent.setAction(AuthenticateAction.LOGON);
            if (userId != null) {
                authenticateEvent.setAuthenticationEntity(EventLoggingUtil.createUser(userId));
            }
            if (!successful.booleanValue()) {
                AuthenticateOutcome outcome = new AuthenticateOutcome();
                outcome.setSuccess(Boolean.FALSE);
                if (reason != null) {
                    outcome.setReason(reason);
                }
                authenticateEvent.setOutcome(outcome);
            }
            EventDetail eventDetail = EventLoggingUtil.createEventDetail(LOGON, LOGON);
            eventDetail.setEventAction(authenticateEvent);
            if (userId != null) {
                event.getEventSource().setUser(EventLoggingUtil.createUser(userId));
            }
            event.setEventDetail(eventDetail);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void logoff(Event event, String userId, Boolean successful) {
        try {
            AuthenticateEventAction authenticateEvent = new AuthenticateEventAction();
            authenticateEvent.setAction(AuthenticateAction.LOGOFF);
            if (userId != null) {
                authenticateEvent.setAuthenticationEntity(EventLoggingUtil.createUser(userId));
            }
            if (!successful.booleanValue()) {
                AuthenticateOutcome outcome = new AuthenticateOutcome();
                outcome.setSuccess(Boolean.FALSE);
                authenticateEvent.setOutcome(outcome);
            }
            EventDetail eventDetail = EventLoggingUtil.createEventDetail(LOGOFF, LOGOFF);
            eventDetail.setEventAction(authenticateEvent);
            if (userId != null) {
                event.getEventSource().setUser(EventLoggingUtil.createUser(userId));
            }
            event.setEventDetail(eventDetail);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

