/*
 * Decompiled with CFR 0.152.
 */
package event.logging.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DateUtil {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("+0000");
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String MILLISECOND_SEPERATOR = ".";
    private static final String TIME_SEPERATOR = "T";
    private static final String TIME_ZONE = "Z";
    private static final String FILE_TIME_FORMAT = "HH#mm#ss";
    private static final String FILE_MILLISECOND_SEPERATOR = ",";
    private static final int MS_IN_SEC = 1000;
    private static final int THREE = 3;
    private static final String NULL = "NULL";

    private DateUtil() {
    }

    public static String createFileDateTimeString(Long ms) {
        if (ms == null) {
            return NULL;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(FILE_TIME_FORMAT);
        sdf.setTimeZone(UTC_TIME_ZONE);
        sdf.getCalendar().setTimeZone(UTC_TIME_ZONE);
        return DateUtil.createDateTimeString(ms, sdf, FILE_MILLISECOND_SEPERATOR);
    }

    public static String createNormalDateTimeString(Long ms) {
        if (ms == null) {
            return NULL;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMAT);
        sdf.setTimeZone(UTC_TIME_ZONE);
        sdf.getCalendar().setTimeZone(UTC_TIME_ZONE);
        return DateUtil.createDateTimeString(ms, sdf, MILLISECOND_SEPERATOR);
    }

    private static String createDateTimeString(long ms, DateFormat timeFormat, String milliSep) {
        long seconds = ms / 1000L;
        long fraction = ms - seconds * 1000L;
        String millis = Long.toString(fraction);
        millis = DateUtil.leftPad(millis, 3, '0');
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(UTC_TIME_ZONE);
        Date date = new Date(ms);
        StringBuilder builder = new StringBuilder(128);
        builder.append(sdf.format(date));
        builder.append(TIME_SEPERATOR);
        builder.append(timeFormat.format(date));
        builder.append(milliSep);
        builder.append(millis);
        builder.append(TIME_ZONE);
        return builder.toString();
    }

    public static Long parseDateTimeString(String date) throws ParseException {
        if (NULL.equals(date) || date == null || date.length() == 0) {
            return null;
        }
        String tmp = date.replace('T', ' ');
        tmp = tmp.replaceAll("#", ":");
        tmp = tmp.replaceAll(FILE_MILLISECOND_SEPERATOR, MILLISECOND_SEPERATOR);
        tmp = tmp.replace(TIME_ZONE, " +0000");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS zzz");
        Calendar cal = Calendar.getInstance(UTC_TIME_ZONE, Locale.ROOT);
        sdf.setCalendar(cal);
        sdf.parse(tmp);
        return cal.getTime().getTime();
    }

    public static String leftPad(String str, int size, char padChar) {
        int len = str.length();
        if (len >= size) {
            return str;
        }
        char[] padding = new char[size];
        Arrays.fill(padding, 0, size - len, padChar);
        str.getChars(0, len, padding, size - len);
        return new String(padding);
    }
}

