/*
 * Decompiled with CFR 0.152.
 */
package event.logging.util;

import event.logging.Device;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceUtil.class);
    private static final String UNKNOWN_IP = "UNKNOWN";

    public static Device createDevice(String hostName, String ipAddress) {
        Device device = new Device();
        device.setHostName(hostName);
        device.setIPAddress(ipAddress);
        return device;
    }

    public static Device createDeviceFromInetAddress(InetAddress inetAddress) {
        Device device = new Device();
        try {
            String ipAddress = DeviceUtil.getValidIP(inetAddress.getHostAddress());
            String hostName = DeviceUtil.getFQDN(inetAddress);
            String macAddress = DeviceUtil.getMACAddress(inetAddress);
            device.setIPAddress(ipAddress);
            device.setHostName(hostName);
            device.setMACAddress(macAddress);
        }
        catch (RuntimeException e) {
            LOGGER.warn("Problem getting device from InetAddress", (Throwable)e);
        }
        return device;
    }

    public static String getValidIP(String ip) {
        if (ip == null) {
            return null;
        }
        String tmp = ip.trim().toUpperCase(Locale.ENGLISH);
        if (tmp.length() == 0 || tmp.contains(UNKNOWN_IP)) {
            return null;
        }
        return tmp;
    }

    private static String getFQDN(InetAddress inetAddress) {
        try {
            String fqdn = inetAddress.getCanonicalHostName();
            if (fqdn == null) {
                LOGGER.warn("FQDN is null (inetAddress=" + inetAddress.toString() + ")");
                return null;
            }
            if (fqdn.equals(inetAddress.getHostAddress())) {
                LOGGER.warn("Problem resolving FQDN (inetAddress=" + inetAddress.toString() + ")");
                return null;
            }
            return fqdn;
        }
        catch (RuntimeException e) {
            LOGGER.warn("Problem resolving FQDN " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getMACAddress(InetAddress inetAddress) {
        try {
            byte[] mac;
            NetworkInterface ni = NetworkInterface.getByInetAddress(inetAddress);
            if (ni != null && (mac = ni.getHardwareAddress()) != null) {
                StringBuilder sb = new StringBuilder();
                for (byte field : mac) {
                    sb.append(String.format("%02X", field));
                    sb.append("-");
                }
                sb.setLength(sb.length() - 1);
                return sb.toString();
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn("Problem identifying MAC address", (Throwable)e);
        }
        catch (SocketException e) {
            LOGGER.warn("Problem identifying MAC address", (Throwable)e);
        }
        return null;
    }
}

