/*
 * Decompiled with CFR 0.152.
 */
package event.logging;

import java.util.Objects;

public class LoggedOutcome<T_RESULT> {
    final T_RESULT result;
    final boolean wasSuccessful;
    final String outcomeDescription;

    private LoggedOutcome(T_RESULT result, boolean wasSuccessful, String outcomeDescription) {
        this.result = result;
        this.wasSuccessful = wasSuccessful;
        this.outcomeDescription = outcomeDescription;
    }

    public static <T_RESULT> LoggedOutcome<T_RESULT> of(T_RESULT result, boolean wasSuccessful, String outcomeDescription) {
        return new LoggedOutcome<T_RESULT>(result, wasSuccessful, outcomeDescription);
    }

    public static <T_RESULT> LoggedOutcome<T_RESULT> success(T_RESULT result) {
        return new LoggedOutcome<T_RESULT>(result, true, null);
    }

    public static LoggedOutcome<Void> success() {
        return new LoggedOutcome<Void>(null, true, null);
    }

    public static <T_RESULT> LoggedOutcome<T_RESULT> failure(T_RESULT result, String outcomeDescription) {
        return new LoggedOutcome<T_RESULT>(result, false, outcomeDescription);
    }

    public static LoggedOutcome<Void> failure(String outcomeDescription) {
        return new LoggedOutcome<Void>(null, false, outcomeDescription);
    }

    public T_RESULT getResult() {
        return this.result;
    }

    public String getOutcomeDescription() {
        return this.outcomeDescription;
    }

    public boolean wasSuccessful() {
        return this.wasSuccessful;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggedOutcome that = (LoggedOutcome)o;
        return this.wasSuccessful == that.wasSuccessful && Objects.equals(this.result, that.result) && Objects.equals(this.outcomeDescription, that.outcomeDescription);
    }

    public int hashCode() {
        return Objects.hash(this.result, this.wasSuccessful, this.outcomeDescription);
    }

    public String toString() {
        return "LoggedOutcome{result=" + this.result + ", wasSuccessful=" + this.wasSuccessful + ", outcomeDescription='" + this.outcomeDescription + '\'' + '}';
    }
}

