/*
 * Decompiled with CFR 0.152.
 */
package event.logging.impl;

import event.logging.impl.LogReceiver;
import event.logging.impl.LoggerLogReceiver;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogReceiverFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogReceiverFactory.class);
    private static final String PROP_LOG_RECEIVER = "event.logging.logreceiver";
    private static final String DEFAULT_LOG_RECEIVER = "event.logging.impl.LoggerLogReceiver";
    private static LogReceiverFactory instance;
    private volatile String lastClassName;
    private volatile LogReceiver logReceiver;

    private LogReceiverFactory() {
    }

    public static synchronized LogReceiverFactory getInstance() {
        if (instance == null) {
            instance = new LogReceiverFactory();
        }
        return instance;
    }

    public synchronized LogReceiver getLogReceiver() {
        String className = System.getProperty(PROP_LOG_RECEIVER);
        if (className != null) {
            className = className.trim();
        }
        if (className == null || className.length() == 0) {
            className = DEFAULT_LOG_RECEIVER;
        }
        if (!className.equals(this.lastClassName)) {
            try {
                LOGGER.info("Using '" + className + "' to receive logs");
                Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                if (LogReceiver.class.isAssignableFrom(clazz)) {
                    try {
                        this.logReceiver = (LogReceiver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                } else {
                    LOGGER.error("Specified class '" + className + "' is not a valid LogReceiver");
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.logReceiver == null) {
            this.logReceiver = new LoggerLogReceiver();
        }
        this.lastClassName = className;
        return this.logReceiver;
    }
}

