/*
 * Decompiled with CFR 0.152.
 */
package event.logging.impl;

import event.logging.ComplexLoggedOutcome;
import event.logging.EventAction;
import event.logging.EventLoggerBuilder;
import event.logging.EventLoggingService;
import event.logging.impl.EventLoggerBuilderImpl;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockEventLoggerBuilder<T_EVENT_ACTION extends EventAction>
extends EventLoggerBuilderImpl<T_EVENT_ACTION> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockEventLoggerBuilder.class);

    public MockEventLoggerBuilder(EventLoggingService eventLoggingService) {
        super(eventLoggingService);
    }

    @Override
    public EventLoggerBuilder.ActionSubBuilder<T_EVENT_ACTION> withSimpleLoggedAction(Runnable loggedAction) {
        return new MockActionSubBuilder(this, eventAction -> {
            loggedAction.run();
            return ComplexLoggedOutcome.success(eventAction);
        });
    }

    @Override
    public EventLoggerBuilder.ActionSubBuilder<T_EVENT_ACTION> withComplexLoggedAction(Function<T_EVENT_ACTION, ComplexLoggedOutcome<Void, T_EVENT_ACTION>> loggedAction) {
        return new MockActionSubBuilder(this, loggedAction);
    }

    @Override
    public <T_RESULT> EventLoggerBuilder.ResultSubBuilder<T_EVENT_ACTION, T_RESULT> withSimpleLoggedResult(Supplier<T_RESULT> loggedWork) {
        return new MockResultSubBuilder(this, eventAction -> ComplexLoggedOutcome.success(loggedWork.get(), eventAction));
    }

    @Override
    public <T_RESULT> EventLoggerBuilder.ResultSubBuilder<T_EVENT_ACTION, T_RESULT> withComplexLoggedResult(Function<T_EVENT_ACTION, ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION>> loggedWork) {
        return new MockResultSubBuilder(this, loggedWork);
    }

    private void debugEvent(String methodName) {
        String typeId = this.getTypeId();
        String description = this.getDescription();
        String eventActionName = this.getEventAction().getClass().getSimpleName();
        String info = String.join((CharSequence)"typeId: '", typeId, "' description: '", description, "' eventActionName: '", eventActionName);
        LOGGER.debug(methodName + "() called for event - " + info);
    }

    public static class MockResultSubBuilder<T_EVENT_ACTION extends EventAction, T_RESULT>
    extends EventLoggerBuilderImpl.ResultSubBuilderImpl<T_EVENT_ACTION, T_RESULT> {
        private static final Logger LOGGER = LoggerFactory.getLogger(MockResultSubBuilder.class);
        private final MockEventLoggerBuilder<T_EVENT_ACTION> mockEventLoggerBuilder;

        private MockResultSubBuilder(MockEventLoggerBuilder<T_EVENT_ACTION> mockEventLoggerBuilder, Function<T_EVENT_ACTION, ComplexLoggedOutcome<T_RESULT, T_EVENT_ACTION>> loggedWork) {
            super(mockEventLoggerBuilder, loggedWork);
            this.mockEventLoggerBuilder = mockEventLoggerBuilder;
        }

        @Override
        public T_RESULT getResultAndLog() {
            if (LOGGER.isDebugEnabled()) {
                ((MockEventLoggerBuilder)this.mockEventLoggerBuilder).debugEvent("getResultAndLog");
            }
            return this.getLoggedWork().apply(this.mockEventLoggerBuilder.getEventAction()).getResult();
        }
    }

    public static class MockActionSubBuilder<T_EVENT_ACTION extends EventAction>
    extends EventLoggerBuilderImpl.ActionSubBuilderImpl<T_EVENT_ACTION> {
        private static final Logger LOGGER = LoggerFactory.getLogger(MockActionSubBuilder.class);
        private final MockEventLoggerBuilder<T_EVENT_ACTION> mockEventLoggerBuilder;

        private MockActionSubBuilder(MockEventLoggerBuilder<T_EVENT_ACTION> mockEventLoggerBuilder, Function<T_EVENT_ACTION, ComplexLoggedOutcome<Void, T_EVENT_ACTION>> loggedAction) {
            super(mockEventLoggerBuilder, loggedAction);
            this.mockEventLoggerBuilder = mockEventLoggerBuilder;
        }

        @Override
        public void runActionAndLog() {
            if (LOGGER.isDebugEnabled()) {
                ((MockEventLoggerBuilder)this.mockEventLoggerBuilder).debugEvent("runActionAndLog");
            }
            this.getLoggedAction().apply(this.mockEventLoggerBuilder.getEventAction());
        }
    }
}

