/*
 * Decompiled with CFR 0.152.
 */
package event.logging.util;

import event.logging.BaseOutcome;
import event.logging.Data;
import event.logging.EventDetail;
import event.logging.EventTime;
import event.logging.Outcome;
import event.logging.Term;
import event.logging.TermCondition;
import event.logging.User;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;

public final class EventLoggingUtil {
    private EventLoggingUtil() {
    }

    public static EventTime createEventTime(Date date) {
        return EventTime.builder().withTimeCreated(date).build();
    }

    public static User createUser(String userId) {
        return ((User.Builder)User.builder().withId(userId)).build();
    }

    public static EventDetail createEventDetail(String typeId, String description) {
        return EventDetail.builder().withTypeId(typeId).withDescription(description).build();
    }

    public static Data createData(String name, String value) {
        return Data.builder().withName(name).withValue(value).build();
    }

    public static Term createTerm(String name, TermCondition condition, String value) {
        return Term.builder().withName(name).withCondition(condition).withValue(value).build();
    }

    public static Outcome createOutcome(Throwable throwable) {
        Outcome outcome = throwable != null ? ((Outcome.Builder)((Outcome.Builder)Outcome.builder().withSuccess(false)).withDescription(throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName())).build() : null;
        return outcome;
    }

    public static <T extends BaseOutcome> T createOutcome(Class<T> outcomeType, Throwable throwable) {
        T outcome = throwable != null ? (T)EventLoggingUtil.createOutcome(outcomeType, false, throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName()) : null;
        return outcome;
    }

    public static Outcome createOutcome(Boolean success, String description) {
        return ((Outcome.Builder)((Outcome.Builder)Outcome.builder().withSuccess(success)).withDescription(description)).build();
    }

    public static <T extends BaseOutcome> T createOutcome(Class<T> outcomeType, Boolean success, String description) {
        BaseOutcome outcome;
        try {
            outcome = (BaseOutcome)outcomeType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error invoking noargs constructor on " + outcomeType.getName(), e);
        }
        outcome.setSuccess(success);
        outcome.setDescription(description);
        return (T)outcome;
    }
}

