/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v1;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import uk.gov.gchq.gaffer.store.StoreTrait;
import uk.gov.gchq.gaffer.store.schema.Schema;

@Path(value="/graph")
@Produces(value={"application/json"})
@Api(value="/graph")
public interface IGraphConfigurationService {
    @GET
    @Path(value="/schema")
    @ApiOperation(value="Gets the schema", response=String.class, responseContainer="list")
    public Schema getSchema();

    @GET
    @Path(value="/description")
    @ApiOperation(value="Gets the Graph description", response=String.class)
    public String getDescription();

    @GET
    @Path(value="/filterFunctions")
    @ApiOperation(value="Gets available filter functions.", response=String.class, responseContainer="list")
    public Set<Class> getFilterFunctions();

    @GET
    @Path(value="/filterFunctions/{inputClass}")
    @ApiOperation(value="Gets available filter functions for the given input class is provided.", response=String.class, responseContainer="list")
    public Set<Class> getFilterFunctions(@ApiParam(value="a function input java class") @PathParam(value="inputClass") String var1);

    @GET
    @Path(value="/transformFunctions")
    @ApiOperation(value="Gets available transform functions", response=String.class, responseContainer="list")
    public Set<Class> getTransformFunctions();

    @GET
    @Path(value="/elementGenerators")
    @ApiOperation(value="Gets available element generators", response=String.class, responseContainer="list")
    public Set<Class> getElementGenerators();

    @GET
    @Path(value="/objectGenerators")
    @ApiOperation(value="Gets available object generators", response=String.class, responseContainer="list")
    public Set<Class> getObjectGenerators();

    @GET
    @Path(value="/operations")
    @ApiOperation(value="Gets all operations supported by the store.", response=String.class, responseContainer="list")
    public Set<Class> getOperations();

    @GET
    @Path(value="/storeTraits")
    @ApiOperation(value="Gets all supported store traits", response=StoreTrait.class, responseContainer="list")
    public Set<StoreTrait> getStoreTraits();

    @GET
    @Path(value="/nextOperations/{className}")
    @ApiOperation(value="Gets all the compatible operations that could be added to an operation chain after the provided operation.", response=String.class, responseContainer="list")
    public Set<Class> getNextOperations(@ApiParam(value="an operation class name") @PathParam(value="className") String var1);

    @POST
    @Path(value="/isOperationSupported")
    @ApiOperation(value="Determines whether the operation type supplied is supported by the store", response=Boolean.class)
    public Boolean isOperationSupported(Class var1);

    @GET
    @Path(value="/serialisedFields/{className}")
    @ApiOperation(value="Gets all serialised fields for a given java class.", response=String.class, responseContainer="list")
    public Set<String> getSerialisedFields(@ApiParam(value="a java class name") @PathParam(value="className") String var1);
}

