/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v1;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import javax.inject.Inject;
import org.glassfish.jersey.server.ChunkedOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.data.element.id.EntityId;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiser;
import uk.gov.gchq.gaffer.operation.Operation;
import uk.gov.gchq.gaffer.operation.OperationChain;
import uk.gov.gchq.gaffer.operation.OperationChainDAO;
import uk.gov.gchq.gaffer.operation.OperationException;
import uk.gov.gchq.gaffer.operation.impl.add.AddElements;
import uk.gov.gchq.gaffer.operation.impl.generate.GenerateElements;
import uk.gov.gchq.gaffer.operation.impl.generate.GenerateObjects;
import uk.gov.gchq.gaffer.operation.impl.get.GetAdjacentIds;
import uk.gov.gchq.gaffer.operation.impl.get.GetAllElements;
import uk.gov.gchq.gaffer.operation.impl.get.GetElements;
import uk.gov.gchq.gaffer.rest.factory.GraphFactory;
import uk.gov.gchq.gaffer.rest.factory.UserFactory;
import uk.gov.gchq.gaffer.rest.service.v1.IOperationService;
import uk.gov.gchq.gaffer.store.Context;

public class OperationService
implements IOperationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationService.class);
    public final ObjectMapper mapper = JSONSerialiser.createDefaultMapper();
    @Inject
    private GraphFactory graphFactory;
    @Inject
    private UserFactory userFactory;

    public Object execute(OperationChainDAO opChain) {
        return this._execute(opChain);
    }

    public Object execute(Operation operation) {
        return this._execute(operation);
    }

    @SuppressFBWarnings
    public ChunkedOutput<String> executeChunkedChain(OperationChainDAO opChain) {
        ChunkedOutput output = new ChunkedOutput(String.class, "\r\n");
        new Thread(() -> {
            try {
                Object result = this._execute(opChain);
                this.chunkResult(result, output);
            }
            finally {
                CloseableUtil.close((AutoCloseable)output);
                CloseableUtil.close((AutoCloseable)opChain);
            }
        }).start();
        return output;
    }

    @SuppressFBWarnings
    public ChunkedOutput<String> executeChunked(Operation operation) {
        if (operation instanceof OperationChainDAO) {
            return this.executeChunkedChain((OperationChainDAO)operation);
        }
        if (operation instanceof OperationChain) {
            return this.executeChunkedChain(new OperationChainDAO(((OperationChain)operation).getOperations()));
        }
        return this.executeChunkedChain(new OperationChainDAO(operation));
    }

    public CloseableIterable<Object> generateObjects(GenerateObjects<Object> operation) {
        return (CloseableIterable)this._execute(operation);
    }

    public CloseableIterable<Element> generateElements(GenerateElements<Object> operation) {
        return (CloseableIterable)this._execute(operation);
    }

    public CloseableIterable<EntityId> getAdjacentIds(GetAdjacentIds operation) {
        return (CloseableIterable)this._execute((Operation)operation);
    }

    public CloseableIterable<Element> getAllElements(GetAllElements operation) {
        return (CloseableIterable)this._execute((Operation)operation);
    }

    public CloseableIterable<Element> getElements(GetElements operation) {
        return (CloseableIterable)this._execute((Operation)operation);
    }

    public void addElements(AddElements operation) {
        this._execute((Operation)operation);
    }

    protected void preOperationHook(OperationChain<?> opChain, Context context) {
    }

    protected void postOperationHook(OperationChain<?> opChain, Context context) {
    }

    protected <O> O _execute(Operation operation) {
        return (O)this._execute(new OperationChainDAO(operation));
    }

    protected <O> O _execute(OperationChainDAO<O> opChain) {
        Object result;
        Context context = this.userFactory.createContext();
        this.preOperationHook(opChain, context);
        try {
            result = this.graphFactory.getGraph().execute(opChain, context);
        }
        catch (OperationException e) {
            CloseableUtil.close(opChain);
            throw new RuntimeException("Error executing operation chain: " + e.getMessage(), e);
        }
        finally {
            try {
                this.postOperationHook(opChain, context);
            }
            catch (Exception e) {
                CloseableUtil.close(opChain);
                throw e;
            }
        }
        return (O)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void chunkResult(Object result, ChunkedOutput<String> output) {
        if (result instanceof Iterable) {
            Iterable itr = (Iterable)result;
            try {
                for (Object item : itr) {
                    output.write((Object)this.mapper.writeValueAsString(item));
                }
            }
            catch (IOException ioe) {
                LOGGER.warn("IOException (chunks)", (Throwable)ioe);
            }
            finally {
                CloseableUtil.close((Object)itr);
            }
        } else {
            try {
                output.write((Object)this.mapper.writeValueAsString(result));
            }
            catch (IOException ioe) {
                LOGGER.warn("IOException (chunks)", (Throwable)ioe);
            }
        }
    }
}

