/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v1.example;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import uk.gov.gchq.gaffer.data.element.Edge;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.data.element.Entity;
import uk.gov.gchq.gaffer.data.element.IdentifierType;
import uk.gov.gchq.gaffer.data.element.function.ElementFilter;
import uk.gov.gchq.gaffer.data.element.id.EdgeId;
import uk.gov.gchq.gaffer.data.element.id.EntityId;
import uk.gov.gchq.gaffer.data.elementdefinition.view.GlobalViewElementDefinition;
import uk.gov.gchq.gaffer.data.elementdefinition.view.View;
import uk.gov.gchq.gaffer.data.elementdefinition.view.ViewElementDefinition;
import uk.gov.gchq.gaffer.operation.Operation;
import uk.gov.gchq.gaffer.operation.OperationChain;
import uk.gov.gchq.gaffer.operation.data.EdgeSeed;
import uk.gov.gchq.gaffer.operation.data.EntitySeed;
import uk.gov.gchq.gaffer.operation.impl.Limit;
import uk.gov.gchq.gaffer.operation.impl.add.AddElements;
import uk.gov.gchq.gaffer.operation.impl.generate.GenerateElements;
import uk.gov.gchq.gaffer.operation.impl.generate.GenerateObjects;
import uk.gov.gchq.gaffer.operation.impl.get.GetAdjacentIds;
import uk.gov.gchq.gaffer.operation.impl.get.GetAllElements;
import uk.gov.gchq.gaffer.operation.impl.get.GetElements;
import uk.gov.gchq.gaffer.operation.io.InputOutput;
import uk.gov.gchq.gaffer.operation.io.Output;
import uk.gov.gchq.gaffer.rest.example.ExampleDomainObject;
import uk.gov.gchq.gaffer.rest.example.ExampleDomainObjectGenerator;
import uk.gov.gchq.gaffer.rest.example.ExampleElementGenerator;
import uk.gov.gchq.gaffer.rest.example.ExampleFilterFunction;
import uk.gov.gchq.gaffer.rest.factory.GraphFactory;
import uk.gov.gchq.gaffer.rest.factory.UserFactory;
import uk.gov.gchq.gaffer.rest.service.v1.example.IExamplesService;
import uk.gov.gchq.gaffer.store.schema.Schema;
import uk.gov.gchq.gaffer.store.schema.SchemaEdgeDefinition;
import uk.gov.gchq.gaffer.store.schema.SchemaElementDefinition;
import uk.gov.gchq.gaffer.store.schema.SchemaEntityDefinition;

public class ExamplesService
implements IExamplesService {
    public static final String TRANSFORMED_PROPERTIES = "transformedProperties";
    @Inject
    private GraphFactory graphFactory;
    @Inject
    private UserFactory userFactory;

    public OperationChain execute() {
        return new OperationChain.Builder().first((Output)this.getAllElements()).then((InputOutput)new Limit.Builder().resultLimit(Integer.valueOf(1)).build()).build();
    }

    public Operation executeOperation() {
        return this.getAllElements();
    }

    public OperationChain executeChunked() {
        return this.execute();
    }

    public Operation executeChunkedOperation() {
        return this.executeOperation();
    }

    public GetElements getElementsBySeed() {
        GetElements op = new GetElements();
        ArrayList<Object> seeds = new ArrayList<Object>();
        if (this.hasEntities()) {
            seeds.add(this.getEntityId(1));
        }
        if (this.hasEdges()) {
            seeds.add(this.getEdgeId(1, 2));
        }
        op.setInput(seeds);
        this.populateOperation((Output)op);
        return op;
    }

    public GetElements getRelatedElements() {
        GetElements op = new GetElements();
        ArrayList<Object> seeds = new ArrayList<Object>();
        if (this.hasEntities()) {
            seeds.add(this.getEntityId(1));
        } else if (this.hasEdges()) {
            seeds.add(new EntitySeed(this.getEdgeId(1, 2).getSource()));
        }
        if (this.hasEdges()) {
            seeds.add(this.getEdgeId(1, 2));
        }
        op.setInput(seeds);
        this.populateOperation((Output)op);
        return op;
    }

    public GetAdjacentIds getAdjacentIds() {
        GetAdjacentIds op = new GetAdjacentIds();
        ArrayList<Object> seeds = new ArrayList<Object>();
        if (this.hasEntities()) {
            seeds.add(this.getEntityId(1));
        } else if (this.hasEdges()) {
            seeds.add(new EntitySeed(this.getEdgeId(1, 2).getSource()));
        }
        op.setInput(seeds);
        this.populateOperation((Output)op);
        return op;
    }

    public GetAllElements getAllElements() {
        GetAllElements op = new GetAllElements();
        this.populateOperation((Output)op);
        return op;
    }

    public GetElements getElements() {
        GetElements op = new GetElements();
        ArrayList<Object> seeds = new ArrayList<Object>();
        if (this.hasEntities()) {
            seeds.add(this.getEntityId(1));
        } else if (this.hasEdges()) {
            seeds.add(new EntitySeed(this.getEdgeId(1, 2).getSource()));
        }
        if (this.hasEdges()) {
            seeds.add(this.getEdgeId(1, 2));
        }
        op.setInput(seeds);
        this.populateOperation((Output)op);
        return op;
    }

    public AddElements addElements() {
        AddElements op = new AddElements();
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.hasEntities()) {
            elements.add(this.getEntity(1));
            elements.add(this.getEntity(2));
        }
        if (this.hasEdges()) {
            elements.add(this.getEdge(1, 2));
        }
        op.setInput(elements);
        this.populateOperation((Operation)op);
        return op;
    }

    public GenerateObjects generateObjects() {
        GenerateObjects op = new GenerateObjects((Function)new ExampleDomainObjectGenerator());
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.hasEntities()) {
            elements.add(this.getEntity(1));
            elements.add(this.getEntity(2));
        }
        if (this.hasEdges()) {
            elements.add(this.getEdge(1, 2));
        }
        op.setInput(elements);
        this.populateOperation((Output)op);
        return op;
    }

    public GenerateElements generateElements() {
        GenerateElements op = new GenerateElements((Function)new ExampleElementGenerator());
        ArrayList<ExampleDomainObject> objs = new ArrayList<ExampleDomainObject>();
        if (this.hasEntities()) {
            SchemaElementDefinition entityDef = (SchemaElementDefinition)this.getSchema().getEntity(this.getAnEntityGroup());
            objs.add(new ExampleDomainObject(this.getAnEntityGroup(), new Object[]{this.getExampleVertex(entityDef.getIdentifierClass(IdentifierType.VERTEX), 1)}));
            objs.add(new ExampleDomainObject(this.getAnEntityGroup(), new Object[]{this.getExampleVertex(entityDef.getIdentifierClass(IdentifierType.VERTEX), 2)}));
        }
        if (this.hasEdges()) {
            SchemaElementDefinition edgeDef = (SchemaElementDefinition)this.getSchema().getEdge(this.getAnEdgeGroup());
            objs.add(new ExampleDomainObject(this.getAnEdgeGroup(), new Object[]{this.getExampleVertex(edgeDef.getIdentifierClass(IdentifierType.SOURCE), 1), this.getExampleVertex(edgeDef.getIdentifierClass(IdentifierType.DESTINATION), 1), this.isAnEdgeDirected()}));
        }
        op.setInput(objs);
        this.populateOperation((Output)op);
        return op;
    }

    private Schema getSchema() {
        return this.graphFactory.getGraph().getSchema();
    }

    private void populateOperation(Output operation) {
        this.populateOperation((Operation)operation);
    }

    public View.Builder generateViewBuilder() {
        ViewElementDefinition viewElement;
        View.Builder viewBuilder = new View.Builder();
        if (this.hasEntities()) {
            viewElement = null == this.getAnEntityPropertyName() ? new ViewElementDefinition() : ((ViewElementDefinition.Builder)new ViewElementDefinition.Builder().preAggregationFilter(new ElementFilter.Builder().select(new String[]{this.getAnEntityPropertyName()}).execute((Predicate)new ExampleFilterFunction()).build())).build();
            viewBuilder.entity(this.getAnEntityGroup(), viewElement);
        }
        if (this.hasEdges()) {
            viewElement = null == this.getAnEdgePropertyName() ? new ViewElementDefinition() : ((ViewElementDefinition.Builder)new ViewElementDefinition.Builder().preAggregationFilter(new ElementFilter.Builder().select(new String[]{this.getAnEdgePropertyName()}).execute((Predicate)new ExampleFilterFunction()).build())).build();
            viewBuilder.edge(this.getAnEdgeGroup(), viewElement);
        }
        viewBuilder.globalElements(new GlobalViewElementDefinition[]{((GlobalViewElementDefinition.Builder)new GlobalViewElementDefinition.Builder().groupBy(new String[0])).build()});
        return viewBuilder;
    }

    protected void populateOperation(Operation operation) {
    }

    protected Entity getEntity(int uniqueId) {
        String group = this.getAnEntityGroup();
        SchemaElementDefinition entityDef = (SchemaElementDefinition)this.getSchema().getEntity(group);
        Entity entity = new Entity.Builder().group(group).vertex(this.getExampleVertex(entityDef.getIdentifierClass(IdentifierType.VERTEX), uniqueId)).build();
        this.populateProperties((Element)entity, entityDef, uniqueId);
        return entity;
    }

    protected Edge getEdge(int uniqueId1, int uniqueId2) {
        String group = this.getAnEdgeGroup();
        SchemaElementDefinition edgeDef = (SchemaElementDefinition)this.getSchema().getEdge(group);
        Edge edge = new Edge.Builder().group(group).source(this.getExampleVertex(edgeDef.getIdentifierClass(IdentifierType.SOURCE), uniqueId1)).dest(this.getExampleVertex(edgeDef.getIdentifierClass(IdentifierType.DESTINATION), uniqueId2)).directed(this.isAnEdgeDirected()).build();
        this.populateProperties((Element)edge, edgeDef, uniqueId1);
        return edge;
    }

    protected EntityId getEntityId(int uniqueId) {
        return new EntitySeed(this.getExampleVertex(((SchemaEntityDefinition)this.getSchema().getEntity(this.getAnEntityGroup())).getIdentifierClass(IdentifierType.VERTEX), uniqueId));
    }

    protected EdgeId getEdgeId(int uniqueId1, int uniqueId2) {
        return new EdgeSeed(this.getExampleVertex(((SchemaEdgeDefinition)this.getSchema().getEdge(this.getAnEdgeGroup())).getIdentifierClass(IdentifierType.SOURCE), uniqueId1), this.getExampleVertex(((SchemaEdgeDefinition)this.getSchema().getEdge(this.getAnEdgeGroup())).getIdentifierClass(IdentifierType.DESTINATION), uniqueId2), this.isAnEdgeDirected());
    }

    protected boolean isAnEdgeDirected() {
        return !((SchemaEdgeDefinition)this.getSchema().getEdge(this.getAnEdgeGroup())).getDirected().toLowerCase(Locale.getDefault()).contains("false");
    }

    protected String getAnEntityPropertyName() {
        SchemaElementDefinition entityDef = (SchemaElementDefinition)this.getSchema().getEntity(this.getAnEntityGroup());
        String propertyName = null;
        if (null != entityDef && !entityDef.getProperties().isEmpty()) {
            propertyName = (String)entityDef.getProperties().iterator().next();
        }
        return propertyName;
    }

    protected String getAnEntityGroup() {
        if (!this.getSchema().getEntityGroups().isEmpty()) {
            for (Map.Entry entry : this.getSchema().getEntities().entrySet()) {
                if (null == ((SchemaEntityDefinition)entry.getValue()).getProperties() || ((SchemaEntityDefinition)entry.getValue()).getProperties().isEmpty()) continue;
                return (String)entry.getKey();
            }
            return (String)this.getSchema().getEntityGroups().iterator().next();
        }
        return "exampleEntityGroup";
    }

    protected String getAnEdgePropertyName() {
        SchemaElementDefinition edgeDef = (SchemaElementDefinition)this.getSchema().getEdge(this.getAnEdgeGroup());
        String propertyName = null != edgeDef && !edgeDef.getProperties().isEmpty() ? (String)edgeDef.getProperties().iterator().next() : "examplePropertyName";
        return propertyName;
    }

    protected String getAnEdgeGroup() {
        if (!this.getSchema().getEdgeGroups().isEmpty()) {
            for (Map.Entry entry : this.getSchema().getEdges().entrySet()) {
                if (null == ((SchemaEdgeDefinition)entry.getValue()).getProperties() || ((SchemaEdgeDefinition)entry.getValue()).getProperties().isEmpty()) continue;
                return (String)entry.getKey();
            }
            return (String)this.getSchema().getEdgeGroups().iterator().next();
        }
        return "exampleEdgeGroup";
    }

    protected boolean hasEdges() {
        return !this.getSchema().getEdges().isEmpty();
    }

    protected boolean hasEntities() {
        return !this.getSchema().getEntities().isEmpty();
    }

    protected void populateProperties(Element element, SchemaElementDefinition elementDef, int uniqueId) {
        for (String property : elementDef.getProperties()) {
            element.putProperty(property, this.getExampleValue(elementDef.getPropertyClass(property), uniqueId));
        }
    }

    protected Object getExampleVertex(Class<?> clazz, int uniqueId) {
        if (String.class.equals(clazz) || Object.class.equals(clazz)) {
            return "vertex" + uniqueId;
        }
        return this.getExampleValue(clazz, uniqueId);
    }

    protected Object getExampleValue(Class clazz, int uniqueId) {
        Object value;
        if (null == clazz) {
            value = null;
        } else if (String.class.equals((Object)clazz) || Object.class.equals((Object)clazz)) {
            value = String.valueOf(uniqueId);
        } else if (Integer.class.equals((Object)clazz)) {
            value = uniqueId;
        } else if (Double.class.equals((Object)clazz)) {
            value = (double)uniqueId + 0.1;
        } else if (Long.class.equals((Object)clazz)) {
            value = (long)uniqueId;
        } else if (Float.class.equals((Object)clazz)) {
            value = Float.valueOf(uniqueId);
        } else if (Date.class.equals((Object)clazz)) {
            value = new Date(System.currentTimeMillis() - 10000L + (long)uniqueId);
        } else {
            try {
                List l;
                value = clazz.isEnum() ? (!(l = Arrays.asList(clazz.getEnumConstants())).isEmpty() ? Enum.valueOf(clazz, l.get(0).toString()) : clazz.newInstance()) : clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                value = null;
            }
        }
        return value;
    }
}

