/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v2;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import uk.gov.gchq.gaffer.data.generator.ElementGenerator;
import uk.gov.gchq.gaffer.data.generator.ObjectGenerator;
import uk.gov.gchq.gaffer.rest.ServiceConstants;
import uk.gov.gchq.gaffer.rest.factory.GraphFactory;
import uk.gov.gchq.gaffer.rest.factory.UserFactory;
import uk.gov.gchq.gaffer.rest.service.v2.IGraphConfigurationServiceV2;
import uk.gov.gchq.gaffer.serialisation.util.JsonSerialisationUtil;
import uk.gov.gchq.koryphe.serialisation.json.SimpleClassNameIdResolver;
import uk.gov.gchq.koryphe.signature.Signature;
import uk.gov.gchq.koryphe.util.ReflectionUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class GraphConfigurationServiceV2
implements IGraphConfigurationServiceV2 {
    @Inject
    private GraphFactory graphFactory;
    @Inject
    private UserFactory userFactory;

    public GraphConfigurationServiceV2() {
        GraphConfigurationServiceV2.updateReflectionPaths();
    }

    public static void initialise() {
        GraphConfigurationServiceV2.updateReflectionPaths();
    }

    public Response getSchema() {
        return Response.ok((Object)this.graphFactory.getGraph().getSchema()).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    public Response getFilterFunction() {
        return Response.ok((Object)ReflectionUtil.getSubTypes(Predicate.class)).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Need to wrap all runtime exceptions before they are given to the user")
    public Response getFilterFunction(String inputClass) {
        Class<?> clazz;
        if (StringUtils.isEmpty((CharSequence)inputClass)) {
            return this.getFilterFunction();
        }
        try {
            clazz = Class.forName(SimpleClassNameIdResolver.getClassName((String)inputClass));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Input class was not recognised: " + inputClass, e);
        }
        HashSet<Class> classes = new HashSet<Class>();
        for (Class functionClass : ReflectionUtil.getSubTypes(Predicate.class)) {
            try {
                Predicate function = (Predicate)functionClass.newInstance();
                Signature signature = Signature.getInputSignature((Predicate)function);
                if (null != signature.getNumClasses() && (1 != signature.getNumClasses() || !Signature.UnknownGenericType.class.isAssignableFrom(signature.getClasses()[0]) && !signature.getClasses()[0].isAssignableFrom(clazz))) continue;
                classes.add(functionClass);
            }
            catch (Exception e) {
                classes.add(functionClass);
            }
        }
        return Response.ok(classes).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Need to wrap all runtime exceptions before they are given to the user")
    public Response getSerialisedFields(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(SimpleClassNameIdResolver.getClassName((String)className));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class name was not recognised: " + className, e);
        }
        ObjectMapper mapper = new ObjectMapper();
        JavaType type = mapper.getTypeFactory().constructType(clazz);
        BeanDescription introspection = mapper.getSerializationConfig().introspect(type);
        List properties = introspection.findProperties();
        HashSet<String> fields = new HashSet<String>();
        for (BeanPropertyDefinition property : properties) {
            fields.add(property.getName());
        }
        return Response.ok(fields).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Need to wrap all runtime exceptions before they are given to the user")
    public Response getSerialisedFieldClasses(String className) {
        return Response.ok((Object)JsonSerialisationUtil.getSerialisedFieldClasses((String)className)).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    public Response getDescription() {
        return Response.ok((Object)this.graphFactory.getGraph().getDescription()).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    public Response getTransformFunctions() {
        return Response.ok((Object)ReflectionUtil.getSubTypes(Function.class)).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    public Response getStoreTraits() {
        return Response.ok((Object)this.graphFactory.getGraph().getStoreTraits()).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    public Response getElementGenerators() {
        return Response.ok((Object)ReflectionUtil.getSubTypes(ElementGenerator.class)).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    public Response getObjectGenerators() {
        return Response.ok((Object)ReflectionUtil.getSubTypes(ObjectGenerator.class)).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    private static void updateReflectionPaths() {
        ReflectionUtil.addReflectionPackages((String[])new String[]{System.getProperty("gaffer.package.prefixes", "uk.gov.gchq")});
    }
}

