/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import uk.gov.gchq.gaffer.store.StoreTrait;

@Path(value="/graph/config")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="config")
public interface IGraphConfigurationServiceV2 {
    @GET
    @Path(value="/schema")
    @ApiOperation(value="Gets the schema", notes="Returns the full schema for the Store, which should outline the entire list of Elements to be stored in the Graph.", response=String.class, responseContainer="list", produces="application/json", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response getSchema();

    @GET
    @Path(value="/filterFunctions")
    @ApiOperation(value="Gets available filter functions", notes="Returns (in no particular order) the complete list of fully qualified classpaths, of filtering functions that are available to the user.", response=String.class, responseContainer="list", produces="application/json", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response getFilterFunction();

    @GET
    @Path(value="/filterFunctions/{inputClass}")
    @ApiOperation(value="Gets available filter functions for the given input class", notes="Returns a list of the fully qualified classpaths of all filter functions that are applicable to the queried input class.", response=String.class, responseContainer="list", produces="application/json", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Function not found"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response getFilterFunction(@ApiParam(value="a function input java class") @PathParam(value="inputClass") String var1);

    @GET
    @Path(value="/transformFunctions")
    @ApiOperation(value="Gets available transform functions", notes="Returns a list of the fully qualified classpaths of all available transform functions, in no particular order.", response=String.class, responseContainer="list", produces="application/json", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response getTransformFunctions();

    @GET
    @Path(value="/elementGenerators")
    @ApiOperation(value="Gets available element generators", notes="Returns a list of the fully qualified class paths of the elementGenerators available.", response=String.class, responseContainer="list", produces="application/json", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response getElementGenerators();

    @GET
    @Path(value="/objectGenerators")
    @ApiOperation(value="Gets available object generators", notes="Returns a list of the fully qualified class paths of the objectGenerators available.", response=String.class, responseContainer="list", produces="application/json", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response getObjectGenerators();

    @GET
    @Path(value="/storeTraits")
    @ApiOperation(value="Gets all supported store traits", notes="Returns a list of traits that the current store can support, such as different types of Aggregation and Filtering.", response=StoreTrait.class, responseContainer="list", produces="application/json", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response getStoreTraits();

    @GET
    @Path(value="/serialisedFields/{className}")
    @ApiOperation(value="Gets all serialised fields for a given java class", notes="Provides a map of all serialised (ie, not to be ignored) fields, for a given class, alongside information related to the expected type of the class.", response=String.class, responseContainer="list", produces="application/json", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Class not found"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response getSerialisedFields(@ApiParam(value="The name of the Java class, for which the serialised fields should be retrieved") @PathParam(value="className") String var1);

    @GET
    @Path(value="/serialisedFields/{className}/classes")
    @ApiOperation(value="Gets all serialised fields and their class type, for a given java class", response=String.class, responseContainer="map", produces="application/json", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Class not found"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response getSerialisedFieldClasses(@ApiParam(value="A java class name") @PathParam(value="className") String var1);

    @GET
    @Path(value="/description")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Gets the Graph description", response=String.class, produces="text/plain", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response getDescription();
}

