/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v2;

import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.gaffer.jobtracker.Job;
import uk.gov.gchq.gaffer.jobtracker.JobDetail;
import uk.gov.gchq.gaffer.operation.Operation;
import uk.gov.gchq.gaffer.operation.OperationChain;
import uk.gov.gchq.gaffer.operation.OperationException;
import uk.gov.gchq.gaffer.operation.impl.job.GetAllJobDetails;
import uk.gov.gchq.gaffer.operation.impl.job.GetJobDetails;
import uk.gov.gchq.gaffer.operation.impl.job.GetJobResults;
import uk.gov.gchq.gaffer.operation.io.Output;
import uk.gov.gchq.gaffer.rest.ServiceConstants;
import uk.gov.gchq.gaffer.rest.factory.GraphFactory;
import uk.gov.gchq.gaffer.rest.factory.UserFactory;
import uk.gov.gchq.gaffer.rest.service.v2.IJobServiceV2;

public class JobServiceV2
implements IJobServiceV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobServiceV2.class);
    @Inject
    private GraphFactory graphFactory;
    @Inject
    private UserFactory userFactory;
    @Context
    private UriInfo uriInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response executeJob(Operation operation) throws OperationException {
        uk.gov.gchq.gaffer.store.Context context = this.userFactory.createContext();
        OperationChain opChain = OperationChain.wrap((Operation)operation);
        this.preOperationHook(opChain, context);
        try {
            JobDetail jobDetail = this.graphFactory.getGraph().executeJob((Operation)opChain, context);
            LOGGER.info("Job started = {}", (Object)jobDetail);
            URI location = this.uriInfo.getAbsolutePathBuilder().path(jobDetail.getJobId()).build(new Object[0]);
            Response response = Response.created((URI)location).entity((Object)jobDetail).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).header("job-id", (Object)context.getJobId()).build();
            return response;
        }
        finally {
            this.postOperationHook(opChain, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response executeJob(Job job) throws OperationException {
        uk.gov.gchq.gaffer.store.Context context = this.userFactory.createContext();
        OperationChain chain = OperationChain.wrap((Operation)job.getOperation());
        this.preOperationHook(chain, context);
        try {
            JobDetail jobDetail = this.graphFactory.getGraph().executeJob(job, context);
            LOGGER.info("Job started = {}", (Object)jobDetail);
            URI location = this.uriInfo.getAbsolutePathBuilder().path(jobDetail.getJobId()).build(new Object[0]);
            Response response = Response.created((URI)location).entity((Object)jobDetail).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).header("job-id", (Object)context.getJobId()).build();
            return response;
        }
        finally {
            this.postOperationHook(chain, context);
        }
    }

    public Response details() throws OperationException {
        uk.gov.gchq.gaffer.store.Context context = this.userFactory.createContext();
        return Response.ok((Object)this.graphFactory.getGraph().execute((Output)new GetAllJobDetails(), context)).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).header("job-id", (Object)context.getJobId()).build();
    }

    public Response details(String id) throws OperationException {
        uk.gov.gchq.gaffer.store.Context context = this.userFactory.createContext();
        return Response.ok((Object)this.graphFactory.getGraph().execute((Output)new GetJobDetails.Builder().jobId(id).build(), context)).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).header("job-id", (Object)context.getJobId()).build();
    }

    public Response results(String id) throws OperationException {
        uk.gov.gchq.gaffer.store.Context context = this.userFactory.createContext();
        return Response.ok((Object)this.graphFactory.getGraph().execute((Output)((GetJobResults.Builder)new GetJobResults.Builder().jobId(id)).build(), context)).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).header("job-id", (Object)context.getJobId()).build();
    }

    protected void preOperationHook(OperationChain<?> opChain, uk.gov.gchq.gaffer.store.Context context) {
    }

    protected void postOperationHook(OperationChain<?> opChain, uk.gov.gchq.gaffer.store.Context context) {
    }
}

