/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ChunkedOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;
import uk.gov.gchq.gaffer.commonutil.Required;
import uk.gov.gchq.gaffer.commonutil.exception.UnauthorisedException;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.core.exception.Error;
import uk.gov.gchq.gaffer.core.exception.GafferRuntimeException;
import uk.gov.gchq.gaffer.core.exception.Status;
import uk.gov.gchq.gaffer.graph.GraphRequest;
import uk.gov.gchq.gaffer.graph.GraphResult;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiser;
import uk.gov.gchq.gaffer.operation.Operation;
import uk.gov.gchq.gaffer.operation.OperationChain;
import uk.gov.gchq.gaffer.operation.OperationException;
import uk.gov.gchq.gaffer.operation.io.Output;
import uk.gov.gchq.gaffer.rest.ServiceConstants;
import uk.gov.gchq.gaffer.rest.factory.GraphFactory;
import uk.gov.gchq.gaffer.rest.factory.UserFactory;
import uk.gov.gchq.gaffer.rest.service.v2.IOperationServiceV2;
import uk.gov.gchq.gaffer.rest.service.v2.OperationServiceV2;
import uk.gov.gchq.gaffer.rest.service.v2.example.ExamplesFactory;
import uk.gov.gchq.gaffer.serialisation.util.JsonSerialisationUtil;
import uk.gov.gchq.gaffer.store.Context;
import uk.gov.gchq.koryphe.Summary;
import uk.gov.gchq.koryphe.serialisation.json.SimpleClassNameIdResolver;

/*
 * Exception performing whole class analysis ignored.
 */
public class OperationServiceV2
implements IOperationServiceV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationServiceV2.class);
    @Inject
    private GraphFactory graphFactory;
    @Inject
    private UserFactory userFactory;
    @Inject
    private ExamplesFactory examplesFactory;
    public final ObjectMapper mapper = JSONSerialiser.createDefaultMapper();

    public Response getOperations() {
        return Response.ok((Object)this.graphFactory.getGraph().getSupportedOperations()).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    public Response getOperationDetails() {
        Set supportedOperations = this.graphFactory.getGraph().getSupportedOperations();
        ArrayList<OperationDetail> supportedClassesAsOperationDetail = new ArrayList<OperationDetail>();
        for (Class supportedOperation : supportedOperations) {
            supportedClassesAsOperationDetail.add(new OperationDetail(this, supportedOperation));
        }
        return Response.ok(supportedClassesAsOperationDetail).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    public Response execute(Operation operation) {
        Pair resultAndJobId = this._execute(operation, this.userFactory.createContext());
        return Response.ok((Object)resultAndJobId.getFirst()).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).header("job-id", resultAndJobId.getSecond()).build();
    }

    public Response executeChunked(Operation operation) {
        return this.executeChunkedChain(OperationChain.wrap((Operation)operation));
    }

    @SuppressFBWarnings
    public Response executeChunkedChain(OperationChain opChain) {
        Throwable[] threadException = new Throwable[1];
        ChunkedOutput output = new ChunkedOutput(String.class, "\r\n");
        Context context = this.userFactory.createContext();
        Thread thread = new Thread(() -> {
            try {
                Object result = this._execute((Operation)opChain, context).getFirst();
                this.chunkResult(result, output);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                CloseableUtil.close((AutoCloseable)output);
                CloseableUtil.close((AutoCloseable)opChain);
            }
        });
        thread.setUncaughtExceptionHandler((thread1, exception) -> {
            threadException[0] = exception.getCause();
        });
        thread.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Error.ErrorBuilder().status(Status.INTERNAL_SERVER_ERROR).statusCode(500).simpleMessage(e.getMessage()).build()).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
        }
        if (null != threadException[0]) {
            if (threadException.getClass().equals(UnauthorisedException.class)) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Error.ErrorBuilder().status(Status.FORBIDDEN).statusCode(403).simpleMessage(threadException[0].getMessage()).build()).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Error.ErrorBuilder().status(Status.INTERNAL_SERVER_ERROR).statusCode(500).simpleMessage(threadException[0].getMessage()).build()).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
        }
        return Response.ok((Object)output).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    public Response operationDetails(String className) throws InstantiationException, IllegalAccessException {
        try {
            Class operationClass = this.getOperationClass(className);
            if (this.graphFactory.getGraph().getSupportedOperations().contains(operationClass)) {
                return Response.ok((Object)new OperationDetail(this, operationClass)).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
            }
            LOGGER.info("Class: {} was found on the classpath, but is not supported by the current store.", (Object)className);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new Error.ErrorBuilder().status(Status.NOT_FOUND).statusCode(404).simpleMessage("Class: " + className + " is not supported by the current store.").detailMessage("Class: " + className + " was found on the classpath,but is not supported by the current store.").build()).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Class: {} was not found on the classpath.", (Object)className, (Object)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new Error.ErrorBuilder().status(Status.NOT_FOUND).statusCode(404).simpleMessage("Class: " + className + " was not found on the classpath.").build()).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
        }
    }

    public Response operationExample(String className) throws InstantiationException, IllegalAccessException {
        try {
            return Response.ok((Object)this.generateExampleJson(this.getOperationClass(className))).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Class: {} was not found on the classpath.", (Object)className, (Object)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.info("Unable to create example JSON for class: {}.", (Object)className, (Object)e);
            throw e;
        }
    }

    public Response nextOperations(String operationClassName) {
        Class opClass;
        try {
            opClass = this.getOperationClass(operationClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Operation class was not found: " + operationClassName, e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(operationClassName + " does not extend Operation", e);
        }
        return Response.ok((Object)this.getNextOperations(opClass)).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    protected void preOperationHook(OperationChain<?> opChain, Context context) {
    }

    protected void postOperationHook(OperationChain<?> opChain, Context context) {
    }

    protected <O> Pair<O, String> _execute(Operation operation, Context context) {
        GraphResult result;
        OperationChain opChain = OperationChain.wrap((Operation)operation);
        this.preOperationHook(opChain, context);
        try {
            result = this.graphFactory.getGraph().execute(new GraphRequest((Output)opChain, context));
        }
        catch (OperationException e) {
            CloseableUtil.close((AutoCloseable)operation);
            String message = null != e.getMessage() ? "Error executing opChain: " + e.getMessage() : "Error executing opChain";
            throw new GafferRuntimeException(message, (Throwable)e, e.getStatus());
        }
        finally {
            try {
                this.postOperationHook(opChain, context);
            }
            catch (Exception e) {
                CloseableUtil.close((AutoCloseable)operation);
                throw e;
            }
        }
        return new Pair(result.getResult(), (Object)result.getContext().getJobId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void chunkResult(Object result, ChunkedOutput<String> output) {
        if (result instanceof Iterable) {
            Iterable itr = (Iterable)result;
            try {
                for (Object item : itr) {
                    output.write((Object)this.mapper.writeValueAsString(item));
                }
            }
            catch (IOException ioe) {
                LOGGER.warn("IOException (chunks)", (Throwable)ioe);
            }
            finally {
                CloseableUtil.close((Object)itr);
            }
        } else {
            try {
                output.write((Object)this.mapper.writeValueAsString(result));
            }
            catch (IOException ioe) {
                LOGGER.warn("IOException (chunks)", (Throwable)ioe);
            }
        }
    }

    private Operation generateExampleJson(Class<? extends Operation> opClass) throws IllegalAccessException, InstantiationException {
        return this.examplesFactory.generateExample(opClass);
    }

    private Set<Class<? extends Operation>> getNextOperations(Class<? extends Operation> opClass) {
        return this.graphFactory.getGraph().getNextOperations(opClass);
    }

    private Class<? extends Operation> getOperationClass(String className) throws ClassNotFoundException {
        return Class.forName(SimpleClassNameIdResolver.getClassName((String)className)).asSubclass(Operation.class);
    }

    private List<OperationField> getOperationFields(Class<? extends Operation> opClass) {
        Map fieldsToClassMap = JsonSerialisationUtil.getSerialisedFieldClasses((String)opClass.getName());
        ArrayList<OperationField> operationFields = new ArrayList<OperationField>();
        for (String fieldString : fieldsToClassMap.keySet()) {
            boolean required = false;
            String summary = null;
            Field field = null;
            Set enumOptions = null;
            try {
                field = opClass.getDeclaredField(fieldString);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (null != field) {
                required = null != field.getAnnotation(Required.class);
                summary = OperationServiceV2.getSummaryValue(field.getType());
                if (field.getType().isEnum()) {
                    enumOptions = Stream.of(field.getType().getEnumConstants()).map(Object::toString).collect(Collectors.toSet());
                }
            }
            operationFields.add(new OperationField(this, fieldString, summary, (String)fieldsToClassMap.get(fieldString), enumOptions, required));
        }
        return operationFields;
    }

    private String getOperationOutputType(Operation operation) {
        String outputClass = null;
        if (operation instanceof Output) {
            outputClass = JsonSerialisationUtil.getTypeString((Type)((Output)operation).getOutputTypeReference().getType());
        }
        return outputClass;
    }

    private static String getSummaryValue(Class<?> opClass) {
        Summary summary = opClass.getAnnotation(Summary.class);
        return null != summary && null != summary.value() ? summary.value() : null;
    }

    static /* synthetic */ String access$000(Class x0) {
        return OperationServiceV2.getSummaryValue((Class)x0);
    }

    static /* synthetic */ List access$100(OperationServiceV2 x0, Class x1) {
        return x0.getOperationFields(x1);
    }

    static /* synthetic */ Set access$200(OperationServiceV2 x0, Class x1) {
        return x0.getNextOperations(x1);
    }

    static /* synthetic */ Operation access$300(OperationServiceV2 x0, Class x1) throws IllegalAccessException, InstantiationException {
        return x0.generateExampleJson(x1);
    }

    static /* synthetic */ String access$400(OperationServiceV2 x0, Operation x1) {
        return x0.getOperationOutputType(x1);
    }
}

