/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v2;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import uk.gov.gchq.gaffer.core.exception.Error;
import uk.gov.gchq.gaffer.core.exception.Status;
import uk.gov.gchq.gaffer.rest.ServiceConstants;
import uk.gov.gchq.gaffer.rest.SystemProperty;
import uk.gov.gchq.gaffer.rest.service.v2.IPropertiesServiceV2;

public class PropertiesServiceV2
implements IPropertiesServiceV2 {
    public static final String EXPOSED_PROPERTIES = "gaffer.properties";
    public static final Map<String, String> CORE_EXPOSED_PROPERTIES = PropertiesServiceV2.createCoreExposedProperties();

    private static Map<String, String> createCoreExposedProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("gaffer.properties.app.title", "Gaffer REST");
        map.put("gaffer.properties.app.description", "The Gaffer REST service.");
        map.put("gaffer.properties.app.banner.description", "");
        map.put("gaffer.properties.app.banner.colour", "");
        map.put("gaffer.properties.app.doc.url", "https://gchq.github.io/gaffer-doc/");
        map.put("gaffer.properties.app.logo.link", "https://github.com/gchq/Gaffer");
        map.put("gaffer.properties.app.logo.src", "images/logo.png");
        map.put("gaffer.properties.app.logo.favicon.small", "images/logo.png");
        map.put("gaffer.properties.app.logo.favicon.large", "images/logo.png");
        map.put("gaffer.version", SystemProperty.GAFFER_VERSION_DEFAULT);
        map.put("koryphe.version", SystemProperty.KORYPHE_VERSION_DEFAULT);
        return Collections.unmodifiableMap(map);
    }

    public Response getProperties() {
        LinkedHashMap properties = new LinkedHashMap();
        String customPropNamesCsv = System.getProperty(EXPOSED_PROPERTIES);
        Stream customPropNames = null != customPropNamesCsv ? Arrays.stream(customPropNamesCsv.split(",")) : Stream.empty();
        Stream.concat(CORE_EXPOSED_PROPERTIES.keySet().stream(), customPropNames).filter(StringUtils::isNotEmpty).forEach(prop -> {
            String value = System.getProperty(prop);
            if (null == value) {
                value = (String)CORE_EXPOSED_PROPERTIES.get(prop);
            }
            properties.put(prop, value);
        });
        return Response.ok(Collections.unmodifiableMap(properties)).header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }

    public Response getProperty(String propertyName) {
        String prop;
        String propertiesList;
        boolean isCore = CORE_EXPOSED_PROPERTIES.containsKey(propertyName);
        boolean isExposed = isCore;
        if (!isExposed && null != (propertiesList = System.getProperty(EXPOSED_PROPERTIES))) {
            Object[] props = propertiesList.split(",");
            isExposed = ArrayUtils.contains((Object[])props, (Object)propertyName);
        }
        if (isExposed) {
            prop = System.getProperty(propertyName);
            if (null == prop && isCore) {
                prop = (String)CORE_EXPOSED_PROPERTIES.get(propertyName);
            }
        } else {
            prop = null;
        }
        Response.ResponseBuilder builder = null == prop ? Response.status((int)404).entity((Object)new Error.ErrorBuilder().status(Status.NOT_FOUND).statusCode(404).simpleMessage("Property: " + propertyName + " could not be found.").build()).type(MediaType.APPLICATION_JSON_TYPE) : Response.ok((Object)prop).type(MediaType.TEXT_PLAIN_TYPE);
        return builder.header("X-Gaffer-Media-Type", (Object)ServiceConstants.GAFFER_MEDIA_TYPE).build();
    }
}

