/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.ByteBufferUtil;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.ArrayByteSequence;

public class ByteBufferUtilTest {
    @Test
    public void testNonZeroArrayOffset() {
        byte[] data = "0123456789".getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb1 = ByteBuffer.wrap(data, 3, 4);
        ByteBuffer bb2 = bb1.slice();
        Assert.assertEquals((long)3L, (long)bb2.arrayOffset());
        Assert.assertEquals((long)0L, (long)bb2.position());
        Assert.assertEquals((long)4L, (long)bb2.limit());
        ByteBufferUtilTest.assertEquals("3456", bb2);
        bb2.get();
        ByteBufferUtilTest.assertEquals("456", bb2);
    }

    @Test
    public void testZeroArrayOffsetAndNonZeroPosition() {
        byte[] data = "0123456789".getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb1 = ByteBuffer.wrap(data, 3, 4);
        ByteBufferUtil.toText((ByteBuffer)bb1).toString();
        ByteBufferUtilTest.assertEquals("3456", bb1);
    }

    @Test
    public void testZeroArrayOffsetAndPosition() {
        byte[] data = "0123456789".getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb1 = ByteBuffer.wrap(data, 0, 4);
        ByteBufferUtilTest.assertEquals("0123", bb1);
    }

    @Test
    public void testDirectByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocateDirect(10);
        bb.put("0123456789".getBytes(StandardCharsets.UTF_8));
        bb.rewind();
        ByteBufferUtilTest.assertEquals("0123456789", bb);
        bb.get();
        ByteBufferUtilTest.assertEquals("123456789", bb);
    }

    private static void assertEquals(String expected, ByteBuffer bb) {
        Assert.assertEquals((Object)new Text(expected), (Object)ByteBufferUtil.toText((ByteBuffer)bb));
        Assert.assertEquals((Object)expected, (Object)new String(ByteBufferUtil.toBytes((ByteBuffer)bb), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)expected, (Object)ByteBufferUtil.toString((ByteBuffer)bb));
        List bal = ByteBufferUtil.toBytesList(Collections.singletonList(bb));
        Assert.assertEquals((long)1L, (long)bal.size());
        Assert.assertEquals((Object)expected, (Object)new String((byte[])bal.get(0), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)new ArrayByteSequence(expected), (Object)new ArrayByteSequence(bb));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            ByteBufferUtil.write((DataOutput)dos, (ByteBuffer)bb);
            dos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((Object)expected, (Object)new String(baos.toByteArray(), StandardCharsets.UTF_8));
        ByteArrayInputStream bais = ByteBufferUtil.toByteArrayInputStream((ByteBuffer)bb);
        byte[] buffer = new byte[expected.length()];
        try {
            bais.read(buffer);
            Assert.assertEquals((Object)expected, (Object)new String(buffer, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

