/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import uk.gov.gchq.gaffer.commonutil.iterable.CachingIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.WrappedCloseableIterator;

public class CachingIterableTest {
    private static final List<Integer> SMALL_LIST = Arrays.asList(0, 1, 2, 3, 4);
    private static final List<Integer> LARGE_LIST = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);

    @Test
    public void shouldCacheSmallIterable() {
        CloseableIterable iterable = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        BDDMockito.given((Object)iterable.iterator()).willReturn((Object)new WrappedCloseableIterator(SMALL_LIST.iterator()), (Object[])new CloseableIterator[]{new WrappedCloseableIterator(SMALL_LIST.iterator())});
        CachingIterable cachingIterable = new CachingIterable((Iterable)iterable, 5);
        Assert.assertEquals(SMALL_LIST, (Object)Lists.newArrayList((Iterable)cachingIterable));
        Assert.assertEquals(SMALL_LIST, (Object)Lists.newArrayList((Iterable)cachingIterable));
        ((CloseableIterable)Mockito.verify((Object)iterable, (VerificationMode)Mockito.times((int)1))).iterator();
    }

    @Test
    public void shouldNotCacheALargeIterable() {
        CloseableIterable iterable = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        BDDMockito.given((Object)iterable.iterator()).willReturn((Object)new WrappedCloseableIterator(LARGE_LIST.iterator()), (Object[])new CloseableIterator[]{new WrappedCloseableIterator(LARGE_LIST.iterator())});
        CachingIterable cachingIterable = new CachingIterable((Iterable)iterable, 5);
        Assert.assertEquals(LARGE_LIST, (Object)Lists.newArrayList((Iterable)cachingIterable));
        Assert.assertEquals(LARGE_LIST, (Object)Lists.newArrayList((Iterable)cachingIterable));
        ((CloseableIterable)Mockito.verify((Object)iterable, (VerificationMode)Mockito.times((int)2))).iterator();
    }

    @Test
    public void shouldHandleNullIterable() {
        CachingIterable cachingIterable = new CachingIterable(null);
        Assert.assertEquals(Collections.emptyList(), (Object)Lists.newArrayList((Iterable)cachingIterable));
        Assert.assertEquals(Collections.emptyList(), (Object)Lists.newArrayList((Iterable)cachingIterable));
    }

    @Test
    public void shouldCloseTheIterable() {
        CloseableIterable iterable = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        CachingIterable cachingIterable = new CachingIterable((Iterable)iterable, 5);
        cachingIterable.close();
        ((CloseableIterable)Mockito.verify((Object)iterable)).close();
    }

    @Test
    public void shouldCloseTheIterableWhenFullyCached() {
        CloseableIterable iterable = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        BDDMockito.given((Object)iterable.iterator()).willReturn((Object)new WrappedCloseableIterator(SMALL_LIST.iterator()), (Object[])new CloseableIterator[]{new WrappedCloseableIterator(SMALL_LIST.iterator())});
        CachingIterable cachingIterable = new CachingIterable((Iterable)iterable, 5);
        Assert.assertEquals(SMALL_LIST, (Object)Lists.newArrayList((Iterable)cachingIterable));
        ((CloseableIterable)Mockito.verify((Object)iterable)).close();
    }

    @Test
    public void shouldHandleMultipleIterators() {
        CloseableIterable iterable = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        BDDMockito.given((Object)iterable.iterator()).willReturn((Object)new WrappedCloseableIterator(SMALL_LIST.iterator()), (Object[])new CloseableIterator[]{new WrappedCloseableIterator(SMALL_LIST.iterator()), new WrappedCloseableIterator(SMALL_LIST.iterator()), new WrappedCloseableIterator(SMALL_LIST.iterator()), new WrappedCloseableIterator(SMALL_LIST.iterator())});
        CachingIterable cachingIterable = new CachingIterable((Iterable)iterable, 5);
        CloseableIterator itr1 = cachingIterable.iterator();
        itr1.next();
        CloseableIterator itr2 = cachingIterable.iterator();
        itr1.close();
        itr2.next();
        itr1.close();
        CloseableIterator itr3 = cachingIterable.iterator();
        itr3.next();
        CloseableIterator itr4 = cachingIterable.iterator();
        Assert.assertEquals(SMALL_LIST, (Object)Lists.newArrayList((Iterator)itr4));
        ((CloseableIterable)Mockito.verify((Object)iterable, (VerificationMode)Mockito.times((int)3))).close();
        itr3.next();
        ((CloseableIterable)Mockito.verify((Object)iterable, (VerificationMode)Mockito.times((int)4))).iterator();
        Assert.assertEquals(SMALL_LIST, (Object)Lists.newArrayList((Iterable)cachingIterable));
        CloseableIterator itr5 = cachingIterable.iterator();
        Assert.assertEquals((Object)0, (Object)itr5.next());
        ((CloseableIterable)Mockito.verify((Object)iterable, (VerificationMode)Mockito.times((int)4))).iterator();
    }
}

