/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import java.io.Closeable;
import java.io.IOException;
import org.junit.Test;
import org.mockito.Mockito;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;

public class CloseableUtilTest {
    @Test
    public void shouldCloseACloseable() throws IOException {
        Closeable closeable = (Closeable)Mockito.mock(Closeable.class);
        CloseableUtil.close((AutoCloseable)closeable);
        ((Closeable)Mockito.verify((Object)closeable)).close();
    }

    @Test
    public void shouldCloseAllCloseables() throws IOException {
        Closeable closeable1 = (Closeable)Mockito.mock(Closeable.class);
        Closeable closeable2 = (Closeable)Mockito.mock(Closeable.class);
        Object nonCloseable = Mockito.mock(Object.class);
        CloseableUtil.close((Object[])new Object[]{closeable1, nonCloseable, closeable2});
        ((Closeable)Mockito.verify((Object)closeable1)).close();
        ((Closeable)Mockito.verify((Object)closeable2)).close();
    }

    @Test
    public void shouldNotThrowExceptionForNullObject() throws IOException {
        Object obj = null;
        CloseableUtil.close(obj);
    }

    @Test
    public void shouldNotThrowExceptionForNonCloseableObject() throws IOException {
        String obj = "Some string";
        CloseableUtil.close((Object)obj);
    }
}

