/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.CollectionUtil;

public class CollectionUtilTest {
    @Test
    public void shouldReturnTreeSetWithProvidedItem() {
        String item = "test item";
        TreeSet treeSet = CollectionUtil.treeSet((Object)"test item");
        Assert.assertEquals((long)1L, (long)treeSet.size());
        Assert.assertTrue((boolean)treeSet.contains("test item"));
    }

    @Test
    public void shouldReturnTreeSetWithWithOutNullItem() {
        Object item = null;
        TreeSet treeSet = CollectionUtil.treeSet(item);
        Assert.assertEquals((long)0L, (long)treeSet.size());
    }

    @Test
    public void shouldReturnTreeSetWithProvidedItems() {
        Object[] items = new String[]{"test item 1", "test item 2", null};
        TreeSet treeSet = CollectionUtil.treeSet((Object[])items);
        Assert.assertEquals((long)2L, (long)treeSet.size());
        for (Object item : items) {
            if (null == item) continue;
            Assert.assertTrue((boolean)treeSet.contains(item));
        }
    }

    @Test
    public void shouldReturnTreeSetWithNoItemsForNullArray() {
        Object[] items = null;
        TreeSet treeSet = CollectionUtil.treeSet(items);
        Assert.assertEquals((long)0L, (long)treeSet.size());
    }

    @Test
    public void shouldConvertMapToStringKeys() {
        HashMap<Class<Long>, String> map = new HashMap<Class<Long>, String>();
        map.put(Integer.class, "integer");
        map.put(Double.class, "double");
        map.put(Long.class, "long");
        Map result = CollectionUtil.toMapWithStringKeys(map);
        HashMap<String, String> expectedResult = new HashMap<String, String>();
        expectedResult.put(Integer.class.getName(), "integer");
        expectedResult.put(Double.class.getName(), "double");
        expectedResult.put(Long.class.getName(), "long");
        Assert.assertEquals(expectedResult, (Object)result);
    }

    @Test
    public void shouldConvertMapToStringKeysWithProvidedMap() {
        HashMap<Class<Long>, String> map = new HashMap<Class<Long>, String>();
        map.put(Integer.class, "integer");
        map.put(Double.class, "double");
        map.put(Long.class, "long");
        LinkedHashMap result = new LinkedHashMap();
        CollectionUtil.toMapWithStringKeys(map, result);
        LinkedHashMap<String, String> expectedResult = new LinkedHashMap<String, String>();
        expectedResult.put(Integer.class.getName(), "integer");
        expectedResult.put(Double.class.getName(), "double");
        expectedResult.put(Long.class.getName(), "long");
        Assert.assertEquals(expectedResult, result);
    }

    @Test
    public void shouldConvertMapToClassKeys() throws ClassNotFoundException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Integer.class.getName(), "integer");
        map.put(Double.class.getName(), "double");
        map.put(Long.class.getName(), "long");
        Map result = CollectionUtil.toMapWithClassKeys(map);
        HashMap<Class<Long>, String> expectedResult = new HashMap<Class<Long>, String>();
        expectedResult.put(Integer.class, "integer");
        expectedResult.put(Double.class, "double");
        expectedResult.put(Long.class, "long");
        Assert.assertEquals(expectedResult, (Object)result);
    }

    @Test
    public void shouldConvertMapToClassKeysWithProvidedMap() throws ClassNotFoundException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Integer.class.getName(), "integer");
        map.put(Double.class.getName(), "double");
        map.put(Long.class.getName(), "long");
        LinkedHashMap result = new LinkedHashMap();
        CollectionUtil.toMapWithClassKeys(map, result);
        LinkedHashMap<Class<Long>, String> expectedResult = new LinkedHashMap<Class<Long>, String>();
        expectedResult.put(Integer.class, "integer");
        expectedResult.put(Double.class, "double");
        expectedResult.put(Long.class, "long");
        Assert.assertEquals(expectedResult, result);
    }

    @Test
    public void shouldReturnTrueWhenCollectionContainsAProvidedValue() {
        HashSet collection = Sets.newHashSet((Object[])new Integer[]{10, 20, 2, 30});
        Object[] values = new Object[]{1, 2, 3};
        boolean result = CollectionUtil.containsAny((Collection)collection, (Object[])values);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void shouldReturnFalseWhenCollectionDoesNotContainsAProvidedValue() {
        HashSet collection = Sets.newHashSet((Object[])new Integer[]{10, 20, 30});
        Object[] values = new Object[]{1, 2, 3};
        boolean result = CollectionUtil.containsAny((Collection)collection, (Object[])values);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldReturnFalseWhenContainsAnyCalledWithNullValue() {
        HashSet collection = Sets.newHashSet((Object[])new Integer[]{10, 20, 30});
        Object[] values = null;
        boolean result = CollectionUtil.containsAny((Collection)collection, values);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldReturnFalseWhenContainsAnyCalledWithNullCollection() {
        Collection collection = null;
        Object[] values = new Object[]{1, 2, 3};
        boolean result = CollectionUtil.containsAny(collection, (Object[])values);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldReturnFalseWhenAnyMissingCalledWhenTheCollectionContainsAllValues() {
        HashSet collection = Sets.newHashSet((Object[])new Integer[]{10, 20, 30});
        Object[] values = new Object[]{10, 20, 30};
        boolean result = CollectionUtil.anyMissing((Collection)collection, (Object[])values);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldReturnFalseWhenAnyMissingCalledWhenNullValues() {
        HashSet collection = Sets.newHashSet((Object[])new Integer[]{10, 20, 30});
        Object[] values = null;
        boolean result = CollectionUtil.anyMissing((Collection)collection, values);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldReturnTrueWhenAnyMissingCalledWhenTheCollectionDoesNotContainAProvidedValue() {
        HashSet collection = Sets.newHashSet((Object[])new Integer[]{10, 20, 30});
        Object[] values = new Object[]{1, 2, 3};
        boolean result = CollectionUtil.anyMissing((Collection)collection, (Object[])values);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void shouldReturnFalseWhenAnyMissingCalledWithNullValue() {
        HashSet collection = Sets.newHashSet((Object[])new Integer[]{10, 20, 30});
        Object[] values = null;
        boolean result = CollectionUtil.anyMissing((Collection)collection, values);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldReturnTrueWhenAnyMissingCalledWithNullCollectionAndSomeValues() {
        Collection collection = null;
        Object[] values = new Object[]{1, 2, 3};
        boolean result = CollectionUtil.anyMissing(collection, (Object[])values);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void shouldReturnFalseWhenAnyMissingCalledWithNullCollectionAndValues() {
        Collection collection = null;
        Object[] values = null;
        boolean result = CollectionUtil.anyMissing(collection, values);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldReturnTrueWhenDistinctCalledWithCollectionOfUniqueValues() {
        ArrayList collection = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5});
        boolean result = CollectionUtil.distinct((Collection)collection);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void shouldReturnFalseWhenDistinctCalledWithCollectionOfNonUniqueValues() {
        ArrayList collection = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 1, 2});
        boolean result = CollectionUtil.distinct((Collection)collection);
        Assert.assertFalse((boolean)result);
    }
}

