/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import java.time.OffsetDateTime;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.CommonTimeUtil;

public class CommonTimeUtilTest {
    @Test
    public void shouldCorrectlyPlaceTimestampsIntoBuckets() {
        OffsetDateTime offsetDateTime = OffsetDateTime.parse("2000-01-01T12:34:56.789Z");
        long time = offsetDateTime.toInstant().toEpochMilli();
        OffsetDateTime yearOffsetDateTime = OffsetDateTime.parse("2000-02-03T12:34:56.789Z");
        long yearTime = yearOffsetDateTime.toInstant().toEpochMilli();
        Assert.assertEquals((long)OffsetDateTime.parse("2000-01-01T12:34:56.789Z").toInstant().toEpochMilli(), (long)CommonTimeUtil.timeToBucket((long)time, (CommonTimeUtil.TimeBucket)CommonTimeUtil.TimeBucket.MILLISECOND));
        Assert.assertEquals((long)OffsetDateTime.parse("2000-01-01T12:34:56.000Z").toInstant().toEpochMilli(), (long)CommonTimeUtil.timeToBucket((long)time, (CommonTimeUtil.TimeBucket)CommonTimeUtil.TimeBucket.SECOND));
        Assert.assertEquals((long)OffsetDateTime.parse("2000-01-01T12:34:00.000Z").toInstant().toEpochMilli(), (long)CommonTimeUtil.timeToBucket((long)time, (CommonTimeUtil.TimeBucket)CommonTimeUtil.TimeBucket.MINUTE));
        Assert.assertEquals((long)OffsetDateTime.parse("2000-01-01T12:00:00.000Z").toInstant().toEpochMilli(), (long)CommonTimeUtil.timeToBucket((long)time, (CommonTimeUtil.TimeBucket)CommonTimeUtil.TimeBucket.HOUR));
        Assert.assertEquals((long)OffsetDateTime.parse("2000-01-01T00:00:00.000Z").toInstant().toEpochMilli(), (long)CommonTimeUtil.timeToBucket((long)time, (CommonTimeUtil.TimeBucket)CommonTimeUtil.TimeBucket.DAY));
        Assert.assertEquals((long)OffsetDateTime.parse("1999-12-27T00:00:00.000Z").toInstant().toEpochMilli(), (long)CommonTimeUtil.timeToBucket((long)time, (CommonTimeUtil.TimeBucket)CommonTimeUtil.TimeBucket.WEEK));
        Assert.assertEquals((long)OffsetDateTime.parse("2000-01-01T00:00:00.000Z").toInstant().toEpochMilli(), (long)CommonTimeUtil.timeToBucket((long)time, (CommonTimeUtil.TimeBucket)CommonTimeUtil.TimeBucket.MONTH));
        Assert.assertEquals((long)OffsetDateTime.parse("2000-01-01T00:00:00.000Z").toInstant().toEpochMilli(), (long)CommonTimeUtil.timeToBucket((long)yearTime, (CommonTimeUtil.TimeBucket)CommonTimeUtil.TimeBucket.YEAR));
    }
}

