/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public class JsonAssert {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void assertEquals(String expectedJson, String actualJson) {
        try {
            Map expectedSchemaMap = null != expectedJson ? (Map)OBJECT_MAPPER.readValue(expectedJson, Map.class) : Collections.emptyMap();
            Map actualSchemaMap = null != actualJson ? (Map)OBJECT_MAPPER.readValue(actualJson, Map.class) : Collections.emptyMap();
            Assert.assertEquals((Object)expectedSchemaMap, (Object)actualSchemaMap);
            return;
        }
        catch (IOException expectedSchemaMap) {
            try {
                List expectedSchemaMap2 = null != expectedJson ? (List)OBJECT_MAPPER.readValue(expectedJson, List.class) : Collections.emptyList();
                List actualSchemaMap = null != actualJson ? (List)OBJECT_MAPPER.readValue(actualJson, List.class) : Collections.emptyList();
                Assert.assertEquals((Object)expectedSchemaMap2, (Object)actualSchemaMap);
            }
            catch (IOException e) {
                throw new AssertionError(expectedJson + " is not equal to " + actualJson, e);
            }
            return;
        }
    }

    public static void assertEquals(byte[] expectedJson, byte[] actualJson) {
        JsonAssert.assertEquals(null != expectedJson ? new String(expectedJson) : null, null != actualJson ? new String(actualJson) : null);
    }

    public static void assertNotEqual(String firstJson, String secondJson) {
        try {
            Map firstSchemaMap = null != firstJson ? (Map)OBJECT_MAPPER.readValue(firstJson, Map.class) : Collections.emptyMap();
            Map secondSchemaMap = null != secondJson ? (Map)OBJECT_MAPPER.readValue(secondJson, Map.class) : Collections.emptyMap();
            Assert.assertNotEquals((Object)firstSchemaMap, (Object)secondSchemaMap);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void assertNotEqual(byte[] firstJson, byte[] secondJson) {
        JsonAssert.assertNotEqual(null != firstJson ? new String(firstJson) : null, null != secondJson ? new String(secondJson) : null);
    }
}

