/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.JsonAssert;
import uk.gov.gchq.gaffer.commonutil.JsonUtil;

public class JsonUtilTest {
    @Test
    public void shouldReturnTrueWhenJsonObjectsAreEqualButInADifferentOrder() {
        String json1 = "{\"a\": 1, \"b\": 2}";
        String json2 = "{\"b\": 2, \"a\": 1}";
        boolean resultStr = JsonUtil.equals((String)"{\"a\": 1, \"b\": 2}", (String)"{\"b\": 2, \"a\": 1}");
        boolean resultBytes = JsonUtil.equals((byte[])"{\"a\": 1, \"b\": 2}".getBytes(), (byte[])"{\"b\": 2, \"a\": 1}".getBytes());
        Assert.assertTrue((boolean)resultStr);
        Assert.assertTrue((boolean)resultBytes);
        JsonAssert.assertEquals("{\"a\": 1, \"b\": 2}", "{\"b\": 2, \"a\": 1}");
        JsonAssert.assertEquals("{\"a\": 1, \"b\": 2}".getBytes(), "{\"b\": 2, \"a\": 1}".getBytes());
    }

    @Test
    public void shouldReturnFalseWhenJsonObjectsAreDifferentSizes() {
        String json1 = "{\"a\": 1, \"b\": 2}";
        String json2 = "{\"a\": 1, \"b\": 2, \"c\": 3}";
        boolean resultStr = JsonUtil.equals((String)"{\"a\": 1, \"b\": 2}", (String)"{\"a\": 1, \"b\": 2, \"c\": 3}");
        boolean resultBytes = JsonUtil.equals((byte[])"{\"a\": 1, \"b\": 2}".getBytes(), (byte[])"{\"a\": 1, \"b\": 2, \"c\": 3}".getBytes());
        Assert.assertFalse((boolean)resultStr);
        Assert.assertFalse((boolean)resultBytes);
        try {
            JsonAssert.assertEquals("{\"a\": 1, \"b\": 2}", "{\"a\": 1, \"b\": 2, \"c\": 3}");
            Assert.fail((String)"Exception expected");
        }
        catch (AssertionError e) {
            Assert.assertNotNull((Object)((Throwable)((Object)e)).getMessage());
        }
        try {
            JsonAssert.assertEquals("{\"a\": 1, \"b\": 2}".getBytes(), "{\"a\": 1, \"b\": 2, \"c\": 3}".getBytes());
            Assert.fail((String)"Exception expected");
        }
        catch (AssertionError e) {
            Assert.assertNotNull((Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void shouldReturnFalseWhenJsonObjectsAreNotEqual() {
        String json1 = "{\"a\": 1, \"b\": 2}";
        String json2 = "{\"a\": 1, \"b\": 3}";
        boolean resultStr = JsonUtil.equals((String)"{\"a\": 1, \"b\": 2}", (String)"{\"a\": 1, \"b\": 3}");
        boolean resultBytes = JsonUtil.equals((byte[])"{\"a\": 1, \"b\": 2}".getBytes(), (byte[])"{\"a\": 1, \"b\": 3}".getBytes());
        Assert.assertFalse((boolean)resultStr);
        Assert.assertFalse((boolean)resultBytes);
        try {
            JsonAssert.assertEquals("{\"a\": 1, \"b\": 2}", "{\"a\": 1, \"b\": 3}");
            Assert.fail((String)"Exception expected");
        }
        catch (AssertionError e) {
            Assert.assertNotNull((Object)((Throwable)((Object)e)).getMessage());
        }
        try {
            JsonAssert.assertEquals("{\"a\": 1, \"b\": 2}".getBytes(), "{\"a\": 1, \"b\": 3}".getBytes());
            Assert.fail((String)"Exception expected");
        }
        catch (AssertionError e) {
            Assert.assertNotNull((Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void shouldReturnTrueWhenJsonArraysAreEqual() {
        String json1 = "[1,2,3]";
        String json2 = "[1,2,3]";
        boolean resultStr = JsonUtil.equals((String)"[1,2,3]", (String)"[1,2,3]");
        boolean resultBytes = JsonUtil.equals((byte[])"[1,2,3]".getBytes(), (byte[])"[1,2,3]".getBytes());
        Assert.assertTrue((boolean)resultStr);
        Assert.assertTrue((boolean)resultBytes);
        JsonAssert.assertEquals("[1,2,3]", "[1,2,3]");
        JsonAssert.assertEquals("[1,2,3]".getBytes(), "[1,2,3]".getBytes());
    }

    @Test
    public void shouldReturnFalseWhenJsonArraysAreNotEqual() {
        String json1 = "[1,2,3]";
        String json2 = "[1,2,4]";
        boolean resultStr = JsonUtil.equals((String)"[1,2,3]", (String)"[1,2,4]");
        boolean resultBytes = JsonUtil.equals((byte[])"[1,2,3]".getBytes(), (byte[])"[1,2,4]".getBytes());
        Assert.assertFalse((boolean)resultStr);
        Assert.assertFalse((boolean)resultBytes);
        try {
            JsonAssert.assertEquals("[1,2,3]", "[1,2,4]");
            Assert.fail((String)"Exception expected");
        }
        catch (AssertionError e) {
            Assert.assertNotNull((Object)((Throwable)((Object)e)).getMessage());
        }
        try {
            JsonAssert.assertEquals("[1,2,3]".getBytes(), "[1,2,4]".getBytes());
            Assert.fail((String)"Exception expected");
        }
        catch (AssertionError e) {
            Assert.assertNotNull((Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void shouldReturnFalseWhenJsonArraysAreDifferentSizes() {
        String json1 = "[1,2,3]";
        String json2 = "[1,2,3,4]";
        boolean resultStr = JsonUtil.equals((String)"[1,2,3]", (String)"[1,2,3,4]");
        boolean resultBytes = JsonUtil.equals((byte[])"[1,2,3]".getBytes(), (byte[])"[1,2,3,4]".getBytes());
        Assert.assertFalse((boolean)resultStr);
        Assert.assertFalse((boolean)resultBytes);
        try {
            JsonAssert.assertEquals("[1,2,3]", "[1,2,3,4]");
            Assert.fail((String)"Exception expected");
        }
        catch (AssertionError e) {
            Assert.assertNotNull((Object)((Throwable)((Object)e)).getMessage());
        }
        try {
            JsonAssert.assertEquals("[1,2,3]".getBytes(), "[1,2,3,4]".getBytes());
            Assert.fail((String)"Exception expected");
        }
        catch (AssertionError e) {
            Assert.assertNotNull((Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void shouldReturnFalseWhenOneJsonObjectIsNull() {
        String json1 = "{\"a\": 1, \"b\": 2}";
        String json2 = null;
        byte[] json2ToBytes = null;
        boolean resultStr = JsonUtil.equals((String)"{\"a\": 1, \"b\": 2}", json2);
        boolean resultBytes = JsonUtil.equals((byte[])"{\"a\": 1, \"b\": 2}".getBytes(), json2ToBytes);
        Assert.assertFalse((boolean)resultStr);
        Assert.assertFalse((boolean)resultBytes);
        try {
            JsonAssert.assertEquals("{\"a\": 1, \"b\": 2}", json2);
            Assert.fail((String)"Exception expected");
        }
        catch (AssertionError e) {
            Assert.assertNotNull((Object)((Throwable)((Object)e)).getMessage());
        }
        try {
            JsonAssert.assertEquals("{\"a\": 1, \"b\": 2}".getBytes(), json2ToBytes);
            Assert.fail((String)"Exception expected");
        }
        catch (AssertionError e) {
            Assert.assertNotNull((Object)((Throwable)((Object)e)).getMessage());
        }
    }
}

