/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.OneOrMore;

public class OneOrMoreTest {
    @Test
    public void shouldDeduplicateByDefault() {
        OneOrMore collection = new OneOrMore();
        collection.add((Object)1);
        collection.add((Object)1);
        Assert.assertEquals((long)1L, (long)collection.size());
        Assert.assertEquals((long)1L, (long)((Integer)collection.iterator().next()).intValue());
    }

    @Test
    public void shouldAddItemInConstructor() {
        boolean deduplicate = false;
        OneOrMore collection = new OneOrMore(false, (Object)1);
        Assert.assertEquals((long)1L, (long)collection.size());
        Assert.assertEquals((long)1L, (long)((Integer)collection.iterator().next()).intValue());
    }

    @Test
    public void shouldRemoveAnyItem() {
        boolean deduplicate = true;
        OneOrMore collection = new OneOrMore(true, (Object)1);
        collection.removeAnyItem();
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
    }

    @Test
    public void shouldRemoveLastItemInList() {
        boolean deduplicate = false;
        OneOrMore collection = new OneOrMore(false, (Object)1);
        collection.add((Object)2);
        collection.add((Object)3);
        collection.removeAnyItem();
        Assert.assertEquals((long)2L, (long)collection.size());
        Assert.assertEquals(Arrays.asList(1, 2), (Object)Lists.newArrayList((Iterable)collection));
    }

    @Test
    public void shouldAddItemsWithoutDeduplicate() {
        boolean deduplicate = false;
        OneOrMore collection = new OneOrMore(false);
        HashSet expectedItems = new HashSet();
        IntStream.rangeClosed(1, 200).forEach(expectedItems::add);
        for (int i = 200; 0 < i; --i) {
            collection.add((Object)i);
            collection.add((Object)i);
        }
        Assert.assertEquals((long)400L, (long)collection.size());
        Assert.assertEquals(expectedItems, (Object)Sets.newHashSet((Iterable)collection));
    }

    @Test
    public void shouldAddItemsWithDeduplicate() {
        boolean deduplicate = true;
        OneOrMore collection = new OneOrMore(true);
        HashSet expectedItems = new HashSet();
        IntStream.rangeClosed(1, 200).forEach(expectedItems::add);
        for (int i = 200; 0 < i; --i) {
            collection.add((Object)i);
            collection.add((Object)i);
        }
        Assert.assertEquals(expectedItems, (Object)Sets.newHashSet((Iterable)collection));
    }

    @Test
    public void shouldAddAllItemsWithoutDeduplicate() {
        boolean deduplicate = false;
        OneOrMore collection = new OneOrMore(false);
        HashSet expectedItems = new HashSet();
        IntStream.rangeClosed(1, 200).forEach(expectedItems::add);
        collection.addAll(expectedItems);
        collection.addAll(expectedItems);
        Assert.assertEquals((long)(expectedItems.size() * 2), (long)collection.size());
        Assert.assertEquals(expectedItems, (Object)Sets.newHashSet((Iterable)collection));
    }

    @Test
    public void shouldAddAllItemsWithDeduplicate() {
        boolean deduplicate = true;
        OneOrMore collection = new OneOrMore(true);
        HashSet expectedItems = new HashSet();
        IntStream.rangeClosed(1, 200).forEach(expectedItems::add);
        collection.addAll(expectedItems);
        collection.addAll(expectedItems);
        Assert.assertEquals(expectedItems, (Object)Sets.newHashSet((Iterable)collection));
    }

    @Test
    public void shouldGetEmptyIterator() {
        OneOrMore collection = new OneOrMore();
        Iterator itr = collection.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void shouldGetSingletonIterator() {
        OneOrMore collection = new OneOrMore();
        collection.add((Object)1);
        Iterator itr = collection.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((long)1L, (long)((Integer)itr.next()).intValue());
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void shouldBeEqual() {
        OneOrMore collection1 = new OneOrMore(false, (Object)1);
        OneOrMore collection2 = new OneOrMore(false, (Object)1);
        Assert.assertEquals((Object)collection1, (Object)collection2);
        Assert.assertEquals((long)collection1.hashCode(), (long)collection2.hashCode());
    }

    @Test
    public void shouldBeEqualWithDeduplicate() {
        OneOrMore collection1 = new OneOrMore(true, (Object)1);
        OneOrMore collection2 = new OneOrMore(true, (Object)1);
        Assert.assertEquals((Object)collection1, (Object)collection2);
        Assert.assertEquals((long)collection1.hashCode(), (long)collection2.hashCode());
    }

    @Test
    public void shouldBeEqualWithMultipleValues() {
        OneOrMore collection1 = new OneOrMore(false, (Object)1);
        collection1.add((Object)2);
        OneOrMore collection2 = new OneOrMore(false, (Object)1);
        collection2.add((Object)2);
        Assert.assertEquals((Object)collection1, (Object)collection2);
        Assert.assertEquals((long)collection1.hashCode(), (long)collection2.hashCode());
    }

    @Test
    public void shouldBeEqualWithMultipleValuesWithDeduplicate() {
        OneOrMore collection1 = new OneOrMore(true, (Object)1);
        collection1.add((Object)2);
        OneOrMore collection2 = new OneOrMore(true, (Object)1);
        collection2.add((Object)2);
        Assert.assertEquals((Object)collection1, (Object)collection2);
        Assert.assertEquals((long)collection1.hashCode(), (long)collection2.hashCode());
    }

    @Test
    public void shouldNotBeEqual() {
        OneOrMore collection1 = new OneOrMore(false, (Object)1);
        OneOrMore collection2 = new OneOrMore(false, (Object)2);
        Assert.assertNotEquals((Object)collection1, (Object)collection2);
        Assert.assertNotEquals((long)collection1.hashCode(), (long)collection2.hashCode());
    }

    @Test
    public void shouldNotBeEqualWhenDeduplicateDifferent() {
        OneOrMore collection1 = new OneOrMore(false, (Object)1);
        OneOrMore collection2 = new OneOrMore(true, (Object)1);
        Assert.assertNotEquals((Object)collection1, (Object)collection2);
        Assert.assertNotEquals((long)collection1.hashCode(), (long)collection2.hashCode());
    }

    @Test
    public void shouldNotBeEqualWithMultipleValues() {
        OneOrMore collection1 = new OneOrMore(false, (Object)1);
        collection1.add((Object)2);
        OneOrMore collection2 = new OneOrMore(false, (Object)1);
        collection2.add((Object)3);
        Assert.assertNotEquals((Object)collection1, (Object)collection2);
        Assert.assertNotEquals((long)collection1.hashCode(), (long)collection2.hashCode());
    }
}

