/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.DebugUtil;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;

public class ToStringBuilderTest {
    @Before
    public void setUp() throws Exception {
        this.setDebugMode(null);
    }

    @After
    public void after() throws Exception {
        this.setDebugMode(null);
    }

    @Test
    public void testDebugOffToStringBuilder() {
        this.setDebugMode("false");
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)"Test String");
        Assert.assertEquals((Object)ToStringBuilder.SHORT_STYLE, (Object)toStringBuilder.getStyle());
    }

    @Test
    public void testDebugOnToStringBuilder() {
        this.setDebugMode("true");
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)"Test String");
        Assert.assertEquals((Object)ToStringBuilder.FULL_STYLE, (Object)toStringBuilder.getStyle());
    }

    private void setDebugMode(String value) {
        if (null == value) {
            System.clearProperty("gaffer.error-mode.debug");
        } else {
            System.setProperty("gaffer.error-mode.debug", value);
        }
        DebugUtil.updateDebugMode();
    }
}

