/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.elementvisibilityutil;

import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.ArrayByteSequence;

public class ArrayByteSequenceTest {
    ArrayByteSequence abs;
    byte[] data;

    @Before
    public void setUp() {
        this.data = new byte[]{115, 109, 105, 108, 101, 115};
        this.abs = new ArrayByteSequence(this.data);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidByteBufferBounds0() {
        this.abs = new ArrayByteSequence(this.data, -1, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidByteBufferBounds1() {
        this.abs = new ArrayByteSequence(this.data, this.data.length + 1, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidByteBufferBounds2() {
        this.abs = new ArrayByteSequence(this.data, 0, -1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidByteBufferBounds3() {
        this.abs = new ArrayByteSequence(this.data, 6, 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidByteAt0() {
        this.abs.byteAt(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidByteAt1() {
        this.abs.byteAt(this.data.length);
    }

    @Test
    public void testSubSequence() {
        Assert.assertEquals((long)0L, (long)this.abs.subSequence(0, 0).length());
        Assert.assertEquals((Object)"mile", (Object)this.abs.subSequence(1, 5).toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidSubsequence0() {
        this.abs.subSequence(5, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidSubsequence1() {
        this.abs.subSequence(-1, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidSubsequence3() {
        this.abs.subSequence(0, 10);
    }

    @Test
    public void testFromByteBuffer() {
        ByteBuffer bb = ByteBuffer.wrap(this.data, 1, 4);
        this.abs = new ArrayByteSequence(bb);
        Assert.assertEquals((Object)"mile", (Object)this.abs.toString());
        bb = bb.asReadOnlyBuffer();
        this.abs = new ArrayByteSequence(bb);
        Assert.assertEquals((Object)"mile", (Object)this.abs.toString());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((String)"String conversion should round trip correctly", (Object)"", (Object)new ArrayByteSequence("").toString());
    }
}

