/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.elementvisibilityutil;

import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.Authorisations;

public class AuthorisationsTest {
    @Test
    public void testEncodeDecode() {
        Authorisations a = new Authorisations(new String[]{"a", "abcdefg", "hijklmno", ","});
        byte[] array = a.getAuthorisationsArray();
        Authorisations b = new Authorisations(array);
        Assert.assertEquals((Object)a, (Object)b);
        a = new Authorisations();
        array = a.getAuthorisationsArray();
        b = new Authorisations(array);
        Assert.assertEquals((Object)a, (Object)b);
        a = new Authorisations(new String[]{"\u4e94", "b", "c", "\u4e5d"});
        array = a.getAuthorisationsArray();
        b = new Authorisations(array);
        Assert.assertEquals((Object)a, (Object)b);
    }

    @Test
    public void testSerialization() {
        Authorisations a1 = new Authorisations(new String[]{"a", "b"});
        Authorisations a2 = new Authorisations(new String[]{"b", "a"});
        Assert.assertEquals((Object)a1, (Object)a2);
        Assert.assertEquals((Object)a1.serialise(), (Object)a2.serialise());
    }

    @Test
    public void testDefensiveAccess() {
        Authorisations expected = new Authorisations(new String[]{"foo", "a"});
        Authorisations actual = new Authorisations(new String[]{"foo", "a"});
        for (byte[] bytes : actual) {
            bytes[0] = (byte)(bytes[0] + 1);
        }
        Assert.assertArrayEquals((byte[])expected.getAuthorisationsArray(), (byte[])actual.getAuthorisationsArray());
        byte[] byArray = (byte[])actual.getAuthorisations().get(0);
        byArray[0] = (byte)(byArray[0] + 1);
        Assert.assertArrayEquals((byte[])expected.getAuthorisationsArray(), (byte[])actual.getAuthorisationsArray());
        Assert.assertEquals((Object)expected.serialise(), (Object)actual.serialise());
    }

    @Test
    public void testReadOnlyByteBuffer() {
        Authorisations expected = new Authorisations(new String[]{"foo"});
        Authorisations actual = new Authorisations(new String[]{"foo"});
        Assert.assertArrayEquals((byte[])expected.getAuthorisationsArray(), (byte[])actual.getAuthorisationsArray());
        byte[] byArray = ((ByteBuffer)actual.getAuthorisationsBB().get(0)).array();
        byArray[0] = (byte)(byArray[0] + 1);
        Assert.assertArrayEquals((byte[])expected.getAuthorisationsArray(), (byte[])actual.getAuthorisationsArray());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnmodifiableList() {
        Authorisations expected = new Authorisations(new String[]{"foo"});
        Authorisations actual = new Authorisations(new String[]{"foo"});
        Assert.assertArrayEquals((byte[])expected.getAuthorisationsArray(), (byte[])actual.getAuthorisationsArray());
        actual.getAuthorisationsBB().add(ByteBuffer.wrap(new byte[]{97}));
    }
}

