/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.elementvisibilityutil;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.ElementVisibility;

public class ElementVisibilityTest {
    private void shouldThrow(String ... strings) {
        for (String s : strings) {
            try {
                new ElementVisibility(s.getBytes());
                Assert.fail((String)("Should throw: " + s));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void shouldNotThrow(String ... strings) {
        for (String s : strings) {
            new ElementVisibility(s.getBytes());
        }
    }

    @Test
    public void testEmpty() {
        ElementVisibility a = new ElementVisibility(new byte[0]);
        ElementVisibility b = new ElementVisibility("");
        Assert.assertEquals((Object)a, (Object)b);
    }

    @Test
    public void testSimple() {
        this.shouldNotThrow("test", "(one)");
    }

    @Test
    public void testCompound() {
        this.shouldNotThrow("a|b", "a&b", "ab&bc");
        this.shouldNotThrow("A&B&C&D&E", "A|B|C|D|E", "(A|B|C)", "(A)|B|(C)", "A&(B)&(C)", "A&B&(L)");
        this.shouldNotThrow("_&-&:");
    }

    @Test
    public void testBadCharacters() {
        this.shouldThrow("=", "*", "^", "%", "@");
        this.shouldThrow("a*b");
    }

    @Test
    public void testComplexCompound() {
        this.shouldNotThrow("(a|b)&(x|y)");
        this.shouldNotThrow("a&(x|y)", "(a|b)&(x|y)", "A&(L|M)", "B&(L|M)", "A&B&(L|M)");
        this.shouldNotThrow("A&FOO&(L|M)", "(A|B)&FOO&(L|M)", "A&B&(L|M|FOO)", "((A|B|C)|foo)&bar");
        this.shouldNotThrow("(one&two)|(foo&bar)", "(one|foo)&three", "one|foo|bar", "(one|foo)|bar", "((one|foo)|bar)&two");
    }

    @Test
    public void testDanglingOperators() {
        this.shouldThrow("a|b&");
        this.shouldThrow("(|a)");
        this.shouldThrow("|");
        this.shouldThrow("a|", "|a", "|", "&");
        this.shouldThrow("&(five)", "|(five)", "(five)&", "five|", "a|(b)&", "(&five)", "(five|)");
    }

    @Test
    public void testMissingSeparators() {
        this.shouldThrow("one(five)", "(five)one", "(one)(two)", "a|(b(c))");
    }

    @Test
    public void testMismatchedParentheses() {
        this.shouldThrow("(", ")", "(a&b", "b|a)", "A|B)");
    }

    @Test
    public void testMixedOperators() {
        this.shouldThrow("(A&B)|(C&D)&(E)");
        this.shouldThrow("a|b&c", "A&B&C|D", "(A&B)|(C&D)&(E)");
    }

    @Test
    public void testQuotes() {
        this.shouldThrow("\"\"");
        this.shouldThrow("\"A\"A");
        this.shouldThrow("\"A\"\"B\"");
        this.shouldThrow("(A)\"B\"");
        this.shouldThrow("\"A\"(B)");
        this.shouldThrow("\"A");
        this.shouldThrow("\"");
        this.shouldThrow("\"B");
        this.shouldThrow("A&\"B");
        this.shouldThrow("A&\"B\\'");
        this.shouldNotThrow("\"A\"");
        this.shouldNotThrow("(\"A\")");
        this.shouldNotThrow("A&\"B.D\"");
        this.shouldNotThrow("A&\"B\\\\D\"");
        this.shouldNotThrow("A&\"B\\\"D\"");
    }

    @Test
    public void testToString() {
        ElementVisibility cv = new ElementVisibility(ElementVisibility.quote((String)"a"));
        Assert.assertEquals((Object)"[a]", (Object)cv.toString());
        cv = new ElementVisibility(ElementVisibility.quote((String)"\u4e94"));
        Assert.assertEquals((Object)"[\"\u4e94\"]", (Object)cv.toString());
    }

    @Test
    public void testParseTree() {
        ElementVisibility.Node node = this.parse("(W)|(U&V)");
        this.assertNode(node, ElementVisibility.NodeType.OR, 0, 9);
        this.assertNode((ElementVisibility.Node)node.getChildren().get(0), ElementVisibility.NodeType.TERM, 1, 2);
        this.assertNode((ElementVisibility.Node)node.getChildren().get(1), ElementVisibility.NodeType.AND, 5, 8);
    }

    @Test
    public void testParseTreeWithNoChildren() {
        ElementVisibility.Node node = this.parse("ABC");
        this.assertNode(node, ElementVisibility.NodeType.TERM, 0, 3);
    }

    @Test
    public void testParseTreeWithTwoChildren() {
        ElementVisibility.Node node = this.parse("ABC|DEF");
        this.assertNode(node, ElementVisibility.NodeType.OR, 0, 7);
        this.assertNode((ElementVisibility.Node)node.getChildren().get(0), ElementVisibility.NodeType.TERM, 0, 3);
        this.assertNode((ElementVisibility.Node)node.getChildren().get(1), ElementVisibility.NodeType.TERM, 4, 7);
    }

    @Test
    public void testParseTreeWithParenthesesAndTwoChildren() {
        ElementVisibility.Node node = this.parse("(ABC|DEF)");
        this.assertNode(node, ElementVisibility.NodeType.OR, 1, 8);
        this.assertNode((ElementVisibility.Node)node.getChildren().get(0), ElementVisibility.NodeType.TERM, 1, 4);
        this.assertNode((ElementVisibility.Node)node.getChildren().get(1), ElementVisibility.NodeType.TERM, 5, 8);
    }

    @Test
    public void testParseTreeWithParenthesizedChildren() {
        ElementVisibility.Node node = this.parse("ABC|(DEF&GHI)");
        this.assertNode(node, ElementVisibility.NodeType.OR, 0, 13);
        this.assertNode((ElementVisibility.Node)node.getChildren().get(0), ElementVisibility.NodeType.TERM, 0, 3);
        this.assertNode((ElementVisibility.Node)node.getChildren().get(1), ElementVisibility.NodeType.AND, 5, 12);
        this.assertNode((ElementVisibility.Node)((ElementVisibility.Node)node.getChildren().get((int)1)).children.get(0), ElementVisibility.NodeType.TERM, 5, 8);
        this.assertNode((ElementVisibility.Node)((ElementVisibility.Node)node.getChildren().get((int)1)).children.get(1), ElementVisibility.NodeType.TERM, 9, 12);
    }

    @Test
    public void testParseTreeWithMoreParentheses() {
        ElementVisibility.Node node = this.parse("(W)|(U&V)");
        this.assertNode(node, ElementVisibility.NodeType.OR, 0, 9);
        this.assertNode((ElementVisibility.Node)node.getChildren().get(0), ElementVisibility.NodeType.TERM, 1, 2);
        this.assertNode((ElementVisibility.Node)node.getChildren().get(1), ElementVisibility.NodeType.AND, 5, 8);
        this.assertNode((ElementVisibility.Node)((ElementVisibility.Node)node.getChildren().get((int)1)).children.get(0), ElementVisibility.NodeType.TERM, 5, 6);
        this.assertNode((ElementVisibility.Node)((ElementVisibility.Node)node.getChildren().get((int)1)).children.get(1), ElementVisibility.NodeType.TERM, 7, 8);
    }

    private ElementVisibility.Node parse(String s) {
        ElementVisibility v = new ElementVisibility(s);
        return v.getParseTree();
    }

    private void assertNode(ElementVisibility.Node node, ElementVisibility.NodeType nodeType, int start, int end) {
        Assert.assertEquals((Object)node.type, (Object)nodeType);
        Assert.assertEquals((long)start, (long)node.start);
        Assert.assertEquals((long)end, (long)node.end);
    }
}

