/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.elementvisibilityutil;

import java.util.regex.PatternSyntaxException;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.Authorisations;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.ElementVisibility;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.VisibilityEvaluator;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.exception.VisibilityParseException;

public class VisibilityEvaluatorTest {
    VisibilityEvaluator ve = new VisibilityEvaluator(new Authorisations(new String[]{"one", "two", "three", "four"}));

    @Test
    public void testVisibilityEvaluator() throws VisibilityParseException {
        Assert.assertTrue((boolean)this.ve.evaluate(new ElementVisibility(new byte[0])));
        Assert.assertTrue((String)"'and' test", (boolean)this.ve.evaluate(new ElementVisibility("one&two")));
        Assert.assertTrue((String)"'or' test", (boolean)this.ve.evaluate(new ElementVisibility("foor|four")));
        Assert.assertTrue((String)"'and' and 'or' test", (boolean)this.ve.evaluate(new ElementVisibility("(one&two)|(foo&bar)")));
        for (String marking : new String[]{"one", "one|five", "five|one", "(one)", "(one&two)|(foo&bar)", "(one|foo)&three", "one|foo|bar", "(one|foo)|bar", "((one|foo)|bar)&two"}) {
            Assert.assertTrue((String)marking, (boolean)this.ve.evaluate(new ElementVisibility(marking)));
        }
        for (String marking : new String[]{"five", "one&five", "five&one", "((one|foo)|bar)&goober"}) {
            Assert.assertFalse((String)marking, (boolean)this.ve.evaluate(new ElementVisibility(marking)));
        }
        for (String marking : new String[]{"one(five)", "(five)one", "(one)(two)", "a|(b(c))"}) {
            try {
                this.ve.evaluate(new ElementVisibility(marking));
                Assert.fail((String)(marking + " failed to throw"));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        for (String marking : new String[]{"&(five)", "|(five)", "(five)&", "five|", "a|(b)&", "(&five)", "(five|)"}) {
            try {
                this.ve.evaluate(new ElementVisibility(marking));
                Assert.fail((String)(marking + " failed to throw"));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        for (String marking : new String[]{"(", ")", "(a&b", "b|a)"}) {
            try {
                this.ve.evaluate(new ElementVisibility(marking));
                Assert.fail((String)(marking + " failed to throw"));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testQuotedExpressions() throws VisibilityParseException {
        Authorisations auths = new Authorisations(new String[]{"A#C", "A\"C", "A\\C", "AC"});
        VisibilityEvaluator ve = new VisibilityEvaluator(auths);
        Assert.assertTrue((boolean)ve.evaluate(new ElementVisibility(ElementVisibility.quote((String)"A#C") + "|" + ElementVisibility.quote((String)"A?C"))));
        Assert.assertFalse((boolean)ve.evaluate(new ElementVisibility(ElementVisibility.quote((String)"A#C") + "&B")));
        Assert.assertTrue((boolean)ve.evaluate(new ElementVisibility(ElementVisibility.quote((String)"A#C"))));
        Assert.assertTrue((boolean)ve.evaluate(new ElementVisibility("(" + ElementVisibility.quote((String)"A#C") + ")")));
    }

    @Test
    public void testQuote() {
        Assert.assertEquals((Object)"\"A#C\"", (Object)ElementVisibility.quote((String)"A#C"));
        Assert.assertEquals((Object)"\"A\\\"C\"", (Object)ElementVisibility.quote((String)"A\"C"));
        Assert.assertEquals((Object)"\"A\\\"\\\\C\"", (Object)ElementVisibility.quote((String)"A\"\\C"));
        Assert.assertEquals((Object)"ACS", (Object)ElementVisibility.quote((String)"ACS"));
        Assert.assertEquals((Object)"\"\u4e5d\"", (Object)ElementVisibility.quote((String)"\u4e5d"));
        Assert.assertEquals((Object)"\"\u4e94\u5341\"", (Object)ElementVisibility.quote((String)"\u4e94\u5341"));
    }

    @Test
    public void testNonAscii() throws VisibilityParseException {
        VisibilityEvaluator ve = new VisibilityEvaluator(new Authorisations(new String[]{"\u4e94", "\u516d", "\u516b", "\u4e5d", "\u4e94\u5341"}));
        Assert.assertTrue((boolean)ve.evaluate(new ElementVisibility(ElementVisibility.quote((String)"\u4e94") + "|" + ElementVisibility.quote((String)"\u56db"))));
        Assert.assertFalse((boolean)ve.evaluate(new ElementVisibility(ElementVisibility.quote((String)"\u4e94") + "&" + ElementVisibility.quote((String)"\u56db"))));
        Assert.assertTrue((boolean)ve.evaluate(new ElementVisibility(ElementVisibility.quote((String)"\u4e94") + "&(" + ElementVisibility.quote((String)"\u56db") + "|" + ElementVisibility.quote((String)"\u4e5d") + ")")));
        Assert.assertTrue((boolean)ve.evaluate(new ElementVisibility("\"\u4e94\"&(\"\u56db\"|\"\u4e94\u5341\")")));
        Assert.assertFalse((boolean)ve.evaluate(new ElementVisibility(ElementVisibility.quote((String)"\u4e94") + "&(" + ElementVisibility.quote((String)"\u56db") + "|" + ElementVisibility.quote((String)"\u4e09") + ")")));
        Assert.assertFalse((boolean)ve.evaluate(new ElementVisibility("\"\u4e94\"&(\"\u56db\"|\"\u4e09\")")));
    }
}

