/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.iterable.ChainedIterable;

public class ChainedIterableTest {
    @Test
    public void shouldWrapAllIterables() {
        List<Integer> itr1 = Collections.singletonList(0);
        ArrayList itr2 = new ArrayList(0);
        ArrayList itr3 = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
        ArrayList itr4 = Lists.newArrayList((Object[])new Integer[]{5, 6});
        ChainedIterable wrappedItr = new ChainedIterable(new Iterable[]{itr1, itr2, itr3, itr4});
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6}), (Object)Lists.newArrayList((Iterable)wrappedItr));
    }

    @Test
    public void shouldRemoveElementFromFirstIterable() {
        ArrayList itr1 = Lists.newArrayList((Object[])new Integer[]{0});
        ArrayList itr2 = new ArrayList(0);
        ArrayList itr3 = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
        ArrayList itr4 = Lists.newArrayList((Object[])new Integer[]{5, 6});
        int itr1Size = itr1.size();
        int itr2Size = itr2.size();
        int itr3Size = itr3.size();
        int itr4Size = itr4.size();
        ChainedIterable wrappedItr = new ChainedIterable(new Iterable[]{itr1, itr2, itr3, itr4});
        Iterator itr = wrappedItr.iterator();
        Assert.assertEquals((long)0L, (long)((Integer)itr.next()).intValue());
        itr.remove();
        Assert.assertEquals((long)(itr1Size - 1), (long)itr1.size());
        Assert.assertEquals((long)itr2Size, (long)itr2.size());
        Assert.assertEquals((long)itr3Size, (long)itr3.size());
        Assert.assertEquals((long)itr4Size, (long)itr4.size());
    }

    @Test
    public void shouldRemoveElementFromThirdIterable() {
        ArrayList itr1 = Lists.newArrayList((Object[])new Integer[]{0});
        ArrayList itr2 = new ArrayList(0);
        ArrayList itr3 = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
        ArrayList itr4 = Lists.newArrayList((Object[])new Integer[]{5, 6});
        int itr1Size = itr1.size();
        int itr2Size = itr2.size();
        int itr3Size = itr3.size();
        int itr4Size = itr4.size();
        ChainedIterable wrappedItr = new ChainedIterable(new Iterable[]{itr1, itr2, itr3, itr4});
        Iterator itr = wrappedItr.iterator();
        Assert.assertEquals((long)0L, (long)((Integer)itr.next()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)itr.next()).intValue());
        itr.remove();
        Assert.assertEquals((long)itr1Size, (long)itr1.size());
        Assert.assertEquals((long)itr2Size, (long)itr2.size());
        Assert.assertEquals((long)(itr3Size - 1), (long)itr3.size());
        Assert.assertEquals((long)itr4Size, (long)itr4.size());
    }
}

