/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.iterable.ConsumableBlockingQueue;

public class ConsumableBlockingQueueTest {
    @Test
    public void shouldConsumeResultsWhenIterating() {
        ConsumableBlockingQueue queue = new ConsumableBlockingQueue(5);
        IntStream.range(0, 4).forEach(i -> {
            try {
                queue.put((Object)i);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        List items = queue.stream().collect(Collectors.toList());
        Assert.assertEquals(Arrays.asList(0, 1, 2, 3), items);
        Assert.assertTrue((boolean)queue.isEmpty());
        List items2 = queue.stream().collect(Collectors.toList());
        Assert.assertEquals(Collections.emptyList(), items2);
    }

    @Test
    public void shouldBlockOnAdditionWhenQueueIsFull() throws InterruptedException {
        int i;
        ConsumableBlockingQueue queue = new ConsumableBlockingQueue(5);
        boolean[] finishedAdding = new boolean[]{false};
        new Thread(() -> {
            IntStream.range(0, 10).forEach(i -> {
                try {
                    queue.put((Object)i);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
            finishedAdding[0] = true;
        }).start();
        Thread.sleep(1000L);
        Assert.assertFalse((boolean)finishedAdding[0]);
        Iterator consumer = queue.iterator();
        ArrayList items = new ArrayList();
        for (i = 0; i < 4; ++i) {
            Assert.assertTrue((boolean)consumer.hasNext());
            items.add(consumer.next());
        }
        Thread.sleep(1000L);
        Assert.assertFalse((boolean)finishedAdding[0]);
        for (i = 0; i < 4; ++i) {
            Assert.assertTrue((boolean)consumer.hasNext());
            items.add(consumer.next());
        }
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)finishedAdding[0]);
        while (consumer.hasNext()) {
            items.add(consumer.next());
        }
        Assert.assertEquals(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9), items);
    }

    @Test
    public void shouldNotBlockWhenConsumingWhenQueueIsEmpty() {
        ConsumableBlockingQueue queue = new ConsumableBlockingQueue(5);
        Iterator iterator = queue.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

