/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.exception.LimitExceededException;
import uk.gov.gchq.gaffer.commonutil.iterable.LimitedCloseableIterable;

public class LimitedCloseableIterableTest {
    @Test
    public void shouldLimitResultsToFirstItem() {
        List<Integer> values = Arrays.asList(0, 1, 2, 3);
        boolean start = false;
        boolean end = true;
        LimitedCloseableIterable limitedValues = new LimitedCloseableIterable(values, 0, Integer.valueOf(1));
        Assert.assertEquals(values.subList(0, 1), (Object)Lists.newArrayList((Iterable)limitedValues));
    }

    @Test
    public void shouldLimitResultsToLastItem() {
        List<Integer> values = Arrays.asList(0, 1, 2, 3);
        int start = 2;
        int end = Integer.MAX_VALUE;
        LimitedCloseableIterable limitedValues = new LimitedCloseableIterable(values, 2, Integer.valueOf(Integer.MAX_VALUE));
        Assert.assertEquals(values.subList(2, values.size()), (Object)Lists.newArrayList((Iterable)limitedValues));
    }

    @Test
    public void shouldNotLimitResults() {
        List<Integer> values = Arrays.asList(0, 1, 2, 3);
        boolean start = false;
        int end = Integer.MAX_VALUE;
        LimitedCloseableIterable limitedValues = new LimitedCloseableIterable(values, 0, Integer.valueOf(Integer.MAX_VALUE));
        Assert.assertEquals(values, (Object)Lists.newArrayList((Iterable)limitedValues));
    }

    @Test
    public void shouldReturnNoValuesIfStartIsBiggerThanSize() {
        List<Integer> values = Arrays.asList(0, 1, 2, 3);
        int start = 5;
        int end = Integer.MAX_VALUE;
        LimitedCloseableIterable limitedValues = new LimitedCloseableIterable(values, 5, Integer.valueOf(Integer.MAX_VALUE));
        Assert.assertTrue((boolean)Lists.newArrayList((Iterable)limitedValues).isEmpty());
    }

    @Test
    public void shouldThrowExceptionIfStartIsBiggerThanEnd() {
        List<Integer> values = Arrays.asList(0, 1, 2, 3);
        int start = 3;
        boolean end = true;
        try {
            new LimitedCloseableIterable(values, 3, Integer.valueOf(1));
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void shouldThrowExceptionIfDataIsTruncated() {
        List<Integer> values = Arrays.asList(0, 1, 2, 3);
        boolean start = false;
        int end = 2;
        boolean truncate = false;
        LimitedCloseableIterable limitedValues = new LimitedCloseableIterable(values, 0, Integer.valueOf(2), Boolean.valueOf(false));
        try {
            for (Integer n : limitedValues) {
            }
            Assert.fail((String)"Exception expected");
        }
        catch (LimitExceededException e) {
            Assert.assertEquals((Object)"Limit of 2 exceeded.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldHandleNullIterable() {
        LimitedCloseableIterable nullIterable = new LimitedCloseableIterable(null, 0, Integer.valueOf(1), Boolean.valueOf(true));
        Assert.assertTrue((boolean)Lists.newArrayList((Iterable)nullIterable).isEmpty());
    }

    @Test
    public void shouldHandleLimitEqualToIterableLength() {
        List<Integer> values = Arrays.asList(0, 1, 2, 3);
        boolean start = false;
        int end = 4;
        boolean truncate = false;
        LimitedCloseableIterable equalValues = new LimitedCloseableIterable(values, 0, Integer.valueOf(4), Boolean.valueOf(false));
        Assert.assertEquals(values, (Object)Lists.newArrayList((Iterable)equalValues));
    }
}

