/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.iterable.LimitedInMemorySortedIterable;

public class LimitedInMemorySortedIterableTest {
    @Test
    public void shouldLimitEntries() {
        LimitedInMemorySortedIterable list = new LimitedInMemorySortedIterable(Comparator.naturalOrder(), Integer.valueOf(100));
        ArrayList expectedItems = new ArrayList();
        IntStream.rangeClosed(1, 100).forEach(expectedItems::add);
        for (int i = 200; 0 < i; --i) {
            list.add((Object)i);
        }
        Assert.assertEquals(expectedItems, (Object)Lists.newArrayList((Iterable)list));
    }

    @Test
    public void shouldLimitAndDeduplicateEntries() {
        LimitedInMemorySortedIterable list = new LimitedInMemorySortedIterable(Comparator.naturalOrder(), Integer.valueOf(2), true);
        list.add((Object)1);
        list.add((Object)1);
        list.add((Object)2);
        list.add((Object)1);
        list.add((Object)2);
        list.add((Object)10);
        Assert.assertEquals(Arrays.asList(1, 2), (Object)Lists.newArrayList((Iterable)list));
    }

    @Test
    public void shouldDeduplicateEntries() {
        LimitedInMemorySortedIterable list = new LimitedInMemorySortedIterable(Comparator.naturalOrder(), Integer.valueOf(100), true);
        list.add((Object)1);
        list.add((Object)1);
        Assert.assertEquals(Collections.singletonList(1), (Object)Lists.newArrayList((Iterable)list));
    }

    @Test
    public void shouldNotDeduplicateEntries() {
        LimitedInMemorySortedIterable list = new LimitedInMemorySortedIterable(Comparator.naturalOrder(), Integer.valueOf(100), false);
        list.add((Object)1);
        list.add((Object)1);
        Assert.assertEquals(Arrays.asList(1, 1), (Object)Lists.newArrayList((Iterable)list));
    }

    @Test
    public void shouldLimitAndNotDeduplicateEntries() {
        LimitedInMemorySortedIterable list = new LimitedInMemorySortedIterable(Comparator.naturalOrder(), Integer.valueOf(4), false);
        list.add((Object)1);
        list.add((Object)2);
        list.add((Object)1);
        list.add((Object)2);
        list.add((Object)10);
        Assert.assertEquals(Arrays.asList(1, 1, 2, 2), (Object)Lists.newArrayList((Iterable)list));
    }

    @Test
    public void shouldAddAll() {
        LimitedInMemorySortedIterable itr = new LimitedInMemorySortedIterable(Comparator.naturalOrder(), Integer.valueOf(100));
        List evens = IntStream.iterate(0, i -> i + 2).limit(10L).boxed().collect(Collectors.toList());
        boolean evensResult = itr.addAll(evens);
        MatcherAssert.assertThat(evens, (Matcher)IsCollectionWithSize.hasSize((int)10));
        MatcherAssert.assertThat((Object)evensResult, (Matcher)IsEqual.equalTo((Object)true));
        Assert.assertEquals((long)10L, (long)itr.size());
        ArrayList list = Lists.newArrayList((Iterable)itr);
        MatcherAssert.assertThat(list.get(0), (Matcher)IsEqual.equalTo((Object)0));
        MatcherAssert.assertThat(list.get(list.size() - 1), (Matcher)IsEqual.equalTo((Object)18));
        List odds = IntStream.iterate(1, i -> i + 2).limit(10L).boxed().collect(Collectors.toList());
        boolean oddsResult = itr.addAll(odds);
        list = Lists.newArrayList((Iterable)itr);
        MatcherAssert.assertThat(odds, (Matcher)IsCollectionWithSize.hasSize((int)10));
        MatcherAssert.assertThat((Object)oddsResult, (Matcher)IsEqual.equalTo((Object)true));
        MatcherAssert.assertThat((Object)list, (Matcher)IsCollectionWithSize.hasSize((int)20));
        MatcherAssert.assertThat(list.get(0), (Matcher)IsEqual.equalTo((Object)0));
        MatcherAssert.assertThat(list.get(itr.size() - 1), (Matcher)IsEqual.equalTo((Object)19));
    }

    @Test
    public void shouldLimitEntriesOnAddAll() {
        LimitedInMemorySortedIterable itr = new LimitedInMemorySortedIterable(Comparator.naturalOrder(), Integer.valueOf(10));
        List evens = IntStream.iterate(0, i -> i + 2).limit(100L).boxed().collect(Collectors.toList());
        boolean evensResult = itr.addAll(evens);
        ArrayList list = Lists.newArrayList((Iterable)itr);
        MatcherAssert.assertThat(evens, (Matcher)IsCollectionWithSize.hasSize((int)100));
        MatcherAssert.assertThat((Object)evensResult, (Matcher)IsEqual.equalTo((Object)true));
        MatcherAssert.assertThat((Object)list, (Matcher)IsCollectionWithSize.hasSize((int)10));
        MatcherAssert.assertThat(list.get(0), (Matcher)IsEqual.equalTo((Object)0));
        MatcherAssert.assertThat(list.get(itr.size() - 1), (Matcher)IsEqual.equalTo((Object)18));
        List odds = IntStream.iterate(1, i -> i + 2).limit(100L).boxed().collect(Collectors.toList());
        boolean oddsResult = itr.addAll(odds);
        list = Lists.newArrayList((Iterable)itr);
        MatcherAssert.assertThat(odds, (Matcher)IsCollectionWithSize.hasSize((int)100));
        MatcherAssert.assertThat((Object)oddsResult, (Matcher)IsEqual.equalTo((Object)true));
        MatcherAssert.assertThat((Object)list, (Matcher)IsCollectionWithSize.hasSize((int)10));
        MatcherAssert.assertThat(list.get(0), (Matcher)IsEqual.equalTo((Object)0));
        MatcherAssert.assertThat(list.get(itr.size() - 1), (Matcher)IsEqual.equalTo((Object)9));
    }

    @Test
    public void shouldSortLargeNumberOfItems() {
        int streamSize = 1000000;
        int resultLimit = 10000;
        IntStream stream = new Random().ints(2000000L).distinct().limit(1000000L);
        LimitedInMemorySortedIterable list = new LimitedInMemorySortedIterable(Comparator.naturalOrder(), Integer.valueOf(10000), false);
        stream.forEach(i -> list.add((Object)Math.abs(i)));
        ArrayList elements = Lists.newArrayList((Iterable)list);
        ArrayList sortedElements = Lists.newArrayList((Iterable)list);
        sortedElements.sort(Comparator.naturalOrder());
        Assert.assertEquals((Object)elements, (Object)sortedElements);
    }
}

