/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import java.io.IOException;
import java.util.Iterator;
import java.util.stream.Stream;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.StreamIterable;
import uk.gov.gchq.gaffer.commonutil.stream.StreamSupplier;

public class StreamIterableTest {
    @Test
    public void shouldDelegateIteratorToIterable() {
        StreamSupplier streamSupplier = (StreamSupplier)Mockito.mock(StreamSupplier.class);
        Stream stream = (Stream)Mockito.mock(Stream.class);
        BDDMockito.given((Object)streamSupplier.get()).willReturn((Object)stream);
        StreamIterable wrappedIterable = new StreamIterable(streamSupplier);
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        BDDMockito.given(stream.iterator()).willReturn((Object)iterator);
        CloseableIterator result = wrappedIterable.iterator();
        result.hasNext();
        ((Iterator)Mockito.verify((Object)iterator)).hasNext();
    }

    @Test
    public void shouldDelegateCloseToStreamIterable() throws IOException {
        StreamSupplier streamSupplier = (StreamSupplier)Mockito.mock(StreamSupplier.class);
        Stream stream = (Stream)Mockito.mock(Stream.class);
        BDDMockito.given((Object)streamSupplier.get()).willReturn((Object)stream);
        StreamIterable streamIterable = new StreamIterable(streamSupplier);
        streamIterable.close();
        ((StreamSupplier)Mockito.verify((Object)streamSupplier)).close();
    }
}

