/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.SuppliedIterable;

public class SuppliedIterableTest {
    @Test
    public void shouldRequestNewIterableFromSupplierWhenIteratorInvoked() {
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        List<Integer> iterable1 = Arrays.asList(1, 2, 3);
        List<Integer> iterable2 = Arrays.asList(4, 5, 6);
        BDDMockito.given(supplier.get()).willReturn(iterable1, (Object[])new Iterable[]{iterable2});
        SuppliedIterable suppliedItr = new SuppliedIterable(supplier);
        CloseableIterator result1 = suppliedItr.iterator();
        CloseableIterator result2 = suppliedItr.iterator();
        ((Supplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.times((int)2))).get();
        Assert.assertEquals(iterable1, (Object)Lists.newArrayList((Iterator)result1));
        Assert.assertEquals(iterable2, (Object)Lists.newArrayList((Iterator)result2));
    }

    @Test
    public void shouldCloseIterables() {
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        CloseableIterable iterable1 = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        CloseableIterable iterable2 = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        CloseableIterator iterator1 = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        CloseableIterator iterator2 = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        BDDMockito.given((Object)iterable1.iterator()).willReturn((Object)iterator1);
        BDDMockito.given((Object)iterable2.iterator()).willReturn((Object)iterator2);
        BDDMockito.given(supplier.get()).willReturn((Object)iterable1, (Object[])new Iterable[]{iterable2});
        SuppliedIterable suppliedIter = new SuppliedIterable(supplier);
        suppliedIter.iterator();
        suppliedIter.iterator();
        suppliedIter.close();
        ((CloseableIterable)Mockito.verify((Object)iterable1)).close();
        ((CloseableIterable)Mockito.verify((Object)iterable2)).close();
    }
}

