/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import uk.gov.gchq.gaffer.commonutil.iterable.AlwaysValid;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.TransformIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.Validator;

@RunWith(value=MockitoJUnitRunner.class)
public class TransformIterableTest {
    @Test
    public void shouldCreateIteratorThatReturnsOnlyValidStrings() {
        String item1 = "item 1";
        String item2 = "item 2";
        String item3 = "item 3";
        List<String> items = Arrays.asList("item 1", "item 2", "item 3");
        Validator validator = (Validator)Mockito.mock(Validator.class);
        TransformIterableImpl iterable = new TransformIterableImpl(items, (Validator<String>)validator, true);
        CloseableIterator itr = iterable.iterator();
        BDDMockito.given((Object)validator.validate((Object)"item 1")).willReturn((Object)true);
        BDDMockito.given((Object)validator.validate((Object)"item 2")).willReturn((Object)false);
        BDDMockito.given((Object)validator.validate((Object)"item 3")).willReturn((Object)true);
        boolean hasNext1 = itr.hasNext();
        Assert.assertTrue((boolean)hasNext1);
        String next1 = (String)itr.next();
        Assert.assertEquals((Object)"item 1".toUpperCase(), (Object)next1);
        boolean hasNext2 = itr.hasNext();
        Assert.assertTrue((boolean)hasNext2);
        String next2 = (String)itr.next();
        Assert.assertEquals((Object)"item 3".toUpperCase(), (Object)next2);
    }

    @Test
    public void shouldCreateIteratorThatThrowsExceptionOnInvalidString() {
        String item1 = "item 1";
        String item2 = "item 2 invalid";
        String item3 = "item 3";
        List<String> items = Arrays.asList("item 1", "item 2 invalid", "item 3");
        Validator validator = (Validator)Mockito.mock(Validator.class);
        TransformIterableImpl iterable = new TransformIterableImpl(items, (Validator<String>)validator, false);
        CloseableIterator itr = iterable.iterator();
        BDDMockito.given((Object)validator.validate((Object)"item 1")).willReturn((Object)true);
        BDDMockito.given((Object)validator.validate((Object)"item 2 invalid")).willReturn((Object)false);
        BDDMockito.given((Object)validator.validate((Object)"item 3")).willReturn((Object)true);
        boolean hasNext1 = itr.hasNext();
        Assert.assertTrue((boolean)hasNext1);
        String next1 = (String)itr.next();
        Assert.assertEquals((Object)"item 1".toUpperCase(), (Object)next1);
        try {
            itr.hasNext();
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void shouldThrowExceptionIfNextCalledWhenNoNextString() {
        String item1 = "item 1";
        String item2 = "item 2";
        List<String> items = Arrays.asList("item 1", "item 2");
        Validator validator = (Validator)Mockito.mock(Validator.class);
        TransformIterableImpl iterable = new TransformIterableImpl(items, (Validator<String>)validator);
        CloseableIterator itr = iterable.iterator();
        BDDMockito.given((Object)validator.validate((Object)"item 1")).willReturn((Object)true);
        BDDMockito.given((Object)validator.validate((Object)"item 2")).willReturn((Object)true);
        String validElm1 = (String)itr.next();
        String validElm2 = (String)itr.next();
        Assert.assertEquals((Object)"item 1".toUpperCase(), (Object)validElm1);
        Assert.assertEquals((Object)"item 2".toUpperCase(), (Object)validElm2);
        try {
            itr.next();
            Assert.fail((String)"Exception expected");
        }
        catch (NoSuchElementException e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void shouldThrowExceptionIfRemoveCalled() {
        String item1 = "item 1";
        String item2 = "item 2";
        List<String> items = Arrays.asList("item 1", "item 2");
        Validator validator = (Validator)Mockito.mock(Validator.class);
        TransformIterableImpl iterable = new TransformIterableImpl(items, (Validator<String>)validator);
        CloseableIterator itr = iterable.iterator();
        BDDMockito.given((Object)validator.validate((Object)"item 1")).willReturn((Object)true);
        BDDMockito.given((Object)validator.validate((Object)"item 2")).willReturn((Object)true);
        try {
            itr.remove();
            Assert.fail((String)"Exception expected");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void shouldAutoCloseIterator() {
        boolean autoClose = true;
        CloseableIterable items = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        CloseableIterator itemsIterator = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        BDDMockito.given((Object)items.iterator()).willReturn((Object)itemsIterator);
        BDDMockito.given((Object)itemsIterator.hasNext()).willReturn((Object)false);
        TransformIterableImpl iterable = new TransformIterableImpl((Iterable<String>)items, (Validator<String>)new AlwaysValid(), false, true);
        Lists.newArrayList((Iterable)((Object)iterable));
        ((CloseableIterator)Mockito.verify((Object)itemsIterator, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void shouldNotAutoCloseIterator() {
        boolean autoClose = false;
        CloseableIterable items = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        CloseableIterator itemsIterator = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        BDDMockito.given((Object)items.iterator()).willReturn((Object)itemsIterator);
        BDDMockito.given((Object)itemsIterator.hasNext()).willReturn((Object)false);
        TransformIterableImpl iterable = new TransformIterableImpl((Iterable<String>)items, (Validator<String>)new AlwaysValid(), false, false);
        Lists.newArrayList((Iterable)((Object)iterable));
        ((CloseableIterator)Mockito.verify((Object)itemsIterator, (VerificationMode)Mockito.never())).close();
    }

    private class TransformIterableImpl
    extends TransformIterable<String, String> {
        public TransformIterableImpl() {
            super(null);
        }

        public TransformIterableImpl(Iterable<String> input) {
            super(input);
        }

        public TransformIterableImpl(Iterable<String> input, Validator<String> validator) {
            super(input, validator);
        }

        public TransformIterableImpl(Iterable<String> input, Validator<String> validator, boolean skipInvalid) {
            super(input, validator, skipInvalid);
        }

        public TransformIterableImpl(Iterable<String> input, Validator<String> validator, boolean skipInvalid, boolean autoClose) {
            super(input, validator, skipInvalid, autoClose);
        }

        protected String transform(String item) {
            return item.toUpperCase();
        }
    }
}

