/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import uk.gov.gchq.gaffer.commonutil.iterable.AlwaysValid;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.TransformOneToManyIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.Validator;

@RunWith(value=MockitoJUnitRunner.class)
public class TransformOneToManyIterableTest {
    @Test
    public void shouldCreateIteratorThatReturnsOnlyValidStrings() {
        Object item0 = null;
        String item1 = "item 1";
        String item2a = "item 2a";
        String item2b = "item 2b";
        String item2 = "item 2a,item 2b";
        String item3a = "item 3a";
        String item3b = "item 3b";
        String item3 = "item 3a,item 3b";
        String item4 = "item 4";
        List<String> items = Arrays.asList(item0, "item 1", "item 2a,item 2b", "item 3a,item 3b", "item 4");
        Validator validator = (Validator)Mockito.mock(Validator.class);
        TransformOneToManyIterableImpl iterable = new TransformOneToManyIterableImpl(items, (Validator<String>)validator, true);
        CloseableIterator itr = iterable.iterator();
        BDDMockito.given((Object)validator.validate(item0)).willReturn((Object)true);
        BDDMockito.given((Object)validator.validate((Object)"item 1")).willReturn((Object)true);
        BDDMockito.given((Object)validator.validate((Object)"item 2a,item 2b")).willReturn((Object)false);
        BDDMockito.given((Object)validator.validate((Object)"item 3a,item 3b")).willReturn((Object)true);
        BDDMockito.given((Object)validator.validate((Object)"item 4")).willReturn((Object)true);
        ArrayList output = Lists.newArrayList((Iterator)itr);
        Assert.assertEquals(Arrays.asList("item 1".toUpperCase(), "item 3a".toUpperCase(), "item 3b".toUpperCase(), "item 4".toUpperCase()), (Object)output);
    }

    @Test
    public void shouldCreateIteratorThatThrowsExceptionOnInvalidString() {
        String item1 = "item 1";
        String item2 = "item 2a invalid,item 2b";
        String item3 = "item 3";
        List<String> items = Arrays.asList("item 1", "item 2a invalid,item 2b", "item 3");
        Validator validator = (Validator)Mockito.mock(Validator.class);
        TransformOneToManyIterableImpl iterable = new TransformOneToManyIterableImpl(items, (Validator<String>)validator, false);
        CloseableIterator itr = iterable.iterator();
        BDDMockito.given((Object)validator.validate((Object)"item 1")).willReturn((Object)true);
        BDDMockito.given((Object)validator.validate((Object)"item 2a invalid,item 2b")).willReturn((Object)false);
        BDDMockito.given((Object)validator.validate((Object)"item 3")).willReturn((Object)true);
        boolean hasNext1 = itr.hasNext();
        Assert.assertTrue((boolean)hasNext1);
        String next1 = (String)itr.next();
        Assert.assertEquals((Object)"item 1".toUpperCase(), (Object)next1);
        try {
            itr.hasNext();
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void shouldThrowExceptionIfNextCalledWhenNoNextString() {
        String item1 = "item 1";
        String item2a = "item 2a";
        String item2b = "item 2b";
        String item2 = "item 2a,item 2b";
        List<String> items = Arrays.asList("item 1", "item 2a,item 2b");
        Validator validator = (Validator)Mockito.mock(Validator.class);
        TransformOneToManyIterableImpl iterable = new TransformOneToManyIterableImpl(items, (Validator<String>)validator);
        CloseableIterator itr = iterable.iterator();
        BDDMockito.given((Object)validator.validate((Object)"item 1")).willReturn((Object)true);
        BDDMockito.given((Object)validator.validate((Object)"item 2a,item 2b")).willReturn((Object)true);
        String validElm1 = (String)itr.next();
        String validElm2a = (String)itr.next();
        String validElm2b = (String)itr.next();
        Assert.assertEquals((Object)"item 1".toUpperCase(), (Object)validElm1);
        Assert.assertEquals((Object)"item 2a".toUpperCase(), (Object)validElm2a);
        Assert.assertEquals((Object)"item 2b".toUpperCase(), (Object)validElm2b);
        try {
            itr.next();
            Assert.fail((String)"Exception expected");
        }
        catch (NoSuchElementException e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void shouldThrowExceptionIfRemoveCalled() {
        String item1 = "item 1";
        String item2 = "item 2";
        List<String> items = Arrays.asList("item 1", "item 2");
        Validator validator = (Validator)Mockito.mock(Validator.class);
        TransformOneToManyIterableImpl iterable = new TransformOneToManyIterableImpl(items, (Validator<String>)validator);
        CloseableIterator itr = iterable.iterator();
        BDDMockito.given((Object)validator.validate((Object)"item 1")).willReturn((Object)true);
        BDDMockito.given((Object)validator.validate((Object)"item 2")).willReturn((Object)true);
        try {
            itr.remove();
            Assert.fail((String)"Exception expected");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void shouldAutoCloseIterator() {
        boolean autoClose = true;
        CloseableIterable items = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        CloseableIterator itemsIterator = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        BDDMockito.given((Object)items.iterator()).willReturn((Object)itemsIterator);
        BDDMockito.given((Object)itemsIterator.hasNext()).willReturn((Object)false);
        TransformOneToManyIterableImpl iterable = new TransformOneToManyIterableImpl((Iterable<String>)items, true);
        Lists.newArrayList((Iterable)((Object)iterable));
        ((CloseableIterator)Mockito.verify((Object)itemsIterator, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void shouldNotAutoCloseIterator() {
        boolean autoClose = false;
        CloseableIterable items = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        CloseableIterator itemsIterator = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        BDDMockito.given((Object)items.iterator()).willReturn((Object)itemsIterator);
        BDDMockito.given((Object)itemsIterator.hasNext()).willReturn((Object)false);
        TransformOneToManyIterableImpl iterable = new TransformOneToManyIterableImpl((Iterable<String>)items, false);
        Lists.newArrayList((Iterable)((Object)iterable));
        ((CloseableIterator)Mockito.verify((Object)itemsIterator, (VerificationMode)Mockito.never())).close();
    }

    private class TransformOneToManyIterableImpl
    extends TransformOneToManyIterable<String, String> {
        public TransformOneToManyIterableImpl(Iterable<String> input, boolean autoClose) {
            super(input, (Validator)new AlwaysValid(), false, autoClose);
        }

        public TransformOneToManyIterableImpl(Iterable<String> input, Validator<String> validator) {
            super(input, validator);
        }

        public TransformOneToManyIterableImpl(Iterable<String> input, Validator<String> validator, boolean skipInvalid) {
            super(input, validator, skipInvalid);
        }

        protected Iterable<String> transform(String item) {
            if (null == item) {
                return Collections.emptyList();
            }
            return Arrays.asList(item.toUpperCase().split(","));
        }
    }
}

