/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import java.util.Collections;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import uk.gov.gchq.gaffer.commonutil.iterable.ChainedIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.LimitedCloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.TransformIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.TransformOneToManyIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.WrappedCloseableIterable;

public class WrappedCloseableIterableTest {
    @Test
    public void shouldDelegateIteratorToWrappedCloseableIterable() {
        CloseableIterable closeableIterable = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        WrappedCloseableIterable wrappedIterable = new WrappedCloseableIterable((Iterable)closeableIterable);
        CloseableIterator closeableIterator = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        BDDMockito.given((Object)closeableIterable.iterator()).willReturn((Object)closeableIterator);
        CloseableIterator result = wrappedIterable.iterator();
        Assert.assertEquals((Object)closeableIterator, (Object)result);
    }

    @Test
    public void shouldDelegateIteratorToWrappedIterable() {
        Iterable iterable = (Iterable)Mockito.mock(Iterable.class);
        WrappedCloseableIterable wrappedIterable = new WrappedCloseableIterable(iterable);
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        BDDMockito.given(iterable.iterator()).willReturn((Object)iterator);
        CloseableIterator result = wrappedIterable.iterator();
        result.hasNext();
        ((Iterator)Mockito.verify((Object)iterator)).hasNext();
    }

    @Test
    public void shouldDelegateCloseToWrappedCloseableIterable() {
        CloseableIterable closeableIterable = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        WrappedCloseableIterable wrappedIterable = new WrappedCloseableIterable((Iterable)closeableIterable);
        wrappedIterable.close();
        ((CloseableIterable)Mockito.verify((Object)closeableIterable)).close();
    }

    @Test
    public void shouldDoNothingWhenCloseCalledOnNoncloseableIterable() {
        Iterable iterable = (Iterable)Mockito.mock(Iterable.class);
        WrappedCloseableIterable wrappedIterable = new WrappedCloseableIterable(iterable);
        wrappedIterable.close();
    }

    @Test
    public void shouldDelegateCloseToWrappedIterables() {
        CloseableIterable iterable1 = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        CloseableIterable iterable2 = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        LimitedCloseableIterable limitedIterable = new LimitedCloseableIterable(iterable1, 0, Integer.valueOf(1));
        TransformIterable<Integer, String> transformIterable = new TransformIterable<Integer, String>((Iterable)iterable2){

            protected String transform(Integer item) {
                return item.toString();
            }
        };
        TransformOneToManyIterable<String, Double> transformOneToManyIterable = new TransformOneToManyIterable<String, Double>((Iterable)transformIterable){

            protected Iterable<Double> transform(String item) {
                return Collections.singleton(Double.parseDouble(item));
            }
        };
        ChainedIterable chainedIterable = new ChainedIterable(new Iterable[]{limitedIterable, transformOneToManyIterable});
        WrappedCloseableIterable wrappedIterable = new WrappedCloseableIterable((Iterable)chainedIterable);
        wrappedIterable.close();
        ((CloseableIterable)Mockito.verify((Object)iterable1, (VerificationMode)Mockito.atLeastOnce())).close();
        ((CloseableIterable)Mockito.verify((Object)iterable2, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void shouldDelegateIteratorCloseToWrappedIterables() {
        CloseableIterable iterable1 = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        CloseableIterable iterable2 = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        LimitedCloseableIterable limitedIterable = new LimitedCloseableIterable(iterable1, 0, Integer.valueOf(1));
        TransformIterable<Integer, String> transformIterable = new TransformIterable<Integer, String>((Iterable)iterable2){

            protected String transform(Integer item) {
                return item.toString();
            }
        };
        TransformOneToManyIterable<String, Double> transformOneToManyIterable = new TransformOneToManyIterable<String, Double>((Iterable)transformIterable){

            protected Iterable<Double> transform(String item) {
                return Collections.singleton(Double.parseDouble(item));
            }
        };
        ChainedIterable chainedIterable = new ChainedIterable(new Iterable[]{limitedIterable, transformOneToManyIterable});
        WrappedCloseableIterable wrappedIterable = new WrappedCloseableIterable((Iterable)chainedIterable);
        wrappedIterable.iterator().close();
        ((CloseableIterable)Mockito.verify((Object)iterable1, (VerificationMode)Mockito.atLeastOnce())).close();
        ((CloseableIterable)Mockito.verify((Object)iterable2, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void shouldAutoCloseWrappedIterables() {
        CloseableIterable iterable1 = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        CloseableIterator iterator1 = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        BDDMockito.given((Object)iterable1.iterator()).willReturn((Object)iterator1);
        BDDMockito.given((Object)iterator1.hasNext()).willReturn((Object)false);
        CloseableIterable iterable2 = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        CloseableIterator iterator2 = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        BDDMockito.given((Object)iterable2.iterator()).willReturn((Object)iterator2);
        BDDMockito.given((Object)iterator2.hasNext()).willReturn((Object)false);
        LimitedCloseableIterable limitedIterable = new LimitedCloseableIterable(iterable1, 0, Integer.valueOf(1));
        TransformIterable<Integer, String> transformIterable = new TransformIterable<Integer, String>((Iterable)iterable2){

            protected String transform(Integer item) {
                return item.toString();
            }
        };
        TransformOneToManyIterable<String, Double> transformOneToManyIterable = new TransformOneToManyIterable<String, Double>((Iterable)transformIterable){

            protected Iterable<Double> transform(String item) {
                return Collections.singleton(Double.parseDouble(item));
            }
        };
        ChainedIterable chainedIterable = new ChainedIterable(new Iterable[]{limitedIterable, transformOneToManyIterable});
        WrappedCloseableIterable wrappedIterable = new WrappedCloseableIterable((Iterable)chainedIterable);
        wrappedIterable.iterator().hasNext();
        ((CloseableIterator)Mockito.verify((Object)iterator1, (VerificationMode)Mockito.atLeastOnce())).close();
        ((CloseableIterator)Mockito.verify((Object)iterator2, (VerificationMode)Mockito.atLeastOnce())).close();
    }
}

