/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.stream;

import com.google.common.collect.Iterables;
import java.util.LinkedHashSet;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.iterable.LimitedInMemorySortedIterable;
import uk.gov.gchq.gaffer.commonutil.stream.GafferCollectors;

public class GafferCollectorTest {
    @Test
    public void shouldCollectToLinkedHashSet() {
        IntStream stream = IntStream.range(0, 100);
        Iterable iterable = (Iterable)stream.boxed().collect(GafferCollectors.toLinkedHashSet());
        MatcherAssert.assertThat((Object)iterable, (Matcher)IsInstanceOf.instanceOf(LinkedHashSet.class));
        MatcherAssert.assertThat((Object)Iterables.size((Iterable)iterable), (Matcher)IsEqual.equalTo((Object)100));
    }

    @Test
    public void shouldCollectToLimitedSortedSet() {
        IntStream stream = IntStream.range(0, 100);
        int limit = 50;
        boolean deduplicate = true;
        LimitedInMemorySortedIterable result = (LimitedInMemorySortedIterable)stream.boxed().collect(GafferCollectors.toLimitedInMemorySortedIterable(Integer::compareTo, (Integer)50, (boolean)true));
        Assert.assertEquals((long)50L, (long)result.size());
    }
}

