/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.stream;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.stream.Streams;

public class StreamsTest {
    @Test
    public void shouldCloseIteratorWhenStreamIsClosed() throws Throwable {
        Object firstResult;
        CloseableIterator iterator = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        BDDMockito.given((Object)iterator.hasNext()).willReturn((Object)true, (Object[])new Boolean[]{false});
        String first = "first item";
        BDDMockito.given((Object)iterator.next()).willReturn((Object)"first item", (Object[])new String[]{null, null});
        try (Stream stream = Streams.toStream((Iterator)iterator);){
            firstResult = stream.findFirst().orElseThrow(RuntimeException::new);
        }
        Assert.assertEquals((Object)"first item", firstResult);
        ((CloseableIterator)Mockito.verify((Object)iterator)).close();
    }

    @Test
    public void shouldCloseIterableWhenStreamIsClosed() throws Throwable {
        Object firstResult;
        CloseableIterable iterable = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        CloseableIterator iterator = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        BDDMockito.given((Object)iterable.spliterator()).willReturn(Spliterators.spliteratorUnknownSize(iterator, 0));
        BDDMockito.given((Object)iterator.hasNext()).willReturn((Object)true, (Object[])new Boolean[]{false});
        String first = "first item";
        BDDMockito.given((Object)iterator.next()).willReturn((Object)"first item", (Object[])new String[]{null, null});
        try (Stream stream = Streams.toStream((Iterable)iterable);){
            firstResult = stream.findFirst().orElseThrow(RuntimeException::new);
        }
        Assert.assertEquals((Object)"first item", firstResult);
        ((CloseableIterable)Mockito.verify((Object)iterable)).close();
    }

    @Test
    public void shouldCloseIteratorWhenParallelStreamIsClosed() throws Throwable {
        Object firstResult;
        CloseableIterator iterator = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        BDDMockito.given((Object)iterator.hasNext()).willReturn((Object)true, (Object[])new Boolean[]{false});
        String first = "first item";
        BDDMockito.given((Object)iterator.next()).willReturn((Object)"first item", (Object[])new String[]{null, null});
        try (Stream stream = Streams.toParallelStream((Iterator)iterator);){
            firstResult = stream.findFirst().orElseThrow(RuntimeException::new);
        }
        Assert.assertEquals((Object)"first item", firstResult);
        ((CloseableIterator)Mockito.verify((Object)iterator)).close();
    }

    @Test
    public void shouldCloseIterableWhenParallelStreamIsClosed() throws Throwable {
        Object firstResult;
        CloseableIterable iterable = (CloseableIterable)Mockito.mock(CloseableIterable.class);
        CloseableIterator iterator = (CloseableIterator)Mockito.mock(CloseableIterator.class);
        BDDMockito.given((Object)iterable.spliterator()).willReturn(Spliterators.spliteratorUnknownSize(iterator, 0));
        BDDMockito.given((Object)iterator.hasNext()).willReturn((Object)true, (Object[])new Boolean[]{false});
        String first = "first item";
        BDDMockito.given((Object)iterator.next()).willReturn((Object)"first item", (Object[])new String[]{null, null});
        try (Stream stream = Streams.toParallelStream((Iterable)iterable);){
            firstResult = stream.findFirst().orElseThrow(RuntimeException::new);
        }
        Assert.assertEquals((Object)"first item", firstResult);
        ((CloseableIterable)Mockito.verify((Object)iterable)).close();
    }
}

