/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import uk.gov.gchq.koryphe.serialisation.json.SimpleClassNameIdResolver;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static Iterable[] toIterableArray(Collection<? extends Iterable> collection) {
        if (null == collection) {
            return null;
        }
        return collection.toArray(new Iterable[collection.size()]);
    }

    public static <T> TreeSet<T> treeSet(T item) {
        TreeSet<T> treeSet = new TreeSet<T>();
        if (null != item) {
            treeSet.add(item);
        }
        return treeSet;
    }

    public static <T> TreeSet<T> treeSet(T[] items) {
        TreeSet<T> treeSet = new TreeSet<T>();
        if (null != items) {
            for (T item : items) {
                if (null == item) continue;
                treeSet.add(item);
            }
        }
        return treeSet;
    }

    public static <K, V> void toMapWithClassKeys(Map<String, V> mapAsStrings, Map<Class<? extends K>, V> map) throws ClassNotFoundException {
        for (Map.Entry<String, V> entry : mapAsStrings.entrySet()) {
            map.put(Class.forName(SimpleClassNameIdResolver.getClassName((String)entry.getKey())), entry.getValue());
        }
    }

    public static <K, V> Map<Class<? extends K>, V> toMapWithClassKeys(Map<String, V> mapAsStrings) throws ClassNotFoundException {
        HashMap map = new HashMap(mapAsStrings.size());
        CollectionUtil.toMapWithClassKeys(mapAsStrings, map);
        return map;
    }

    public static <K, V> void toMapWithStringKeys(Map<Class<? extends K>, V> map, Map<String, V> mapAsStrings) {
        for (Map.Entry<Class<K>, V> entry : map.entrySet()) {
            mapAsStrings.put(entry.getKey().getName(), entry.getValue());
        }
    }

    public static <K, V> Map<String, V> toMapWithStringKeys(Map<Class<? extends K>, V> map) {
        HashMap mapAsStrings = new HashMap();
        CollectionUtil.toMapWithStringKeys(map, mapAsStrings);
        return mapAsStrings;
    }

    public static boolean containsAny(Collection collection, Object[] objects) {
        boolean result = false;
        if (null != collection && null != objects) {
            for (Object object : objects) {
                if (!collection.contains(object)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean anyMissing(Collection collection, Object[] objects) {
        boolean result;
        block3: {
            block2: {
                result = false;
                if (null != collection && !collection.isEmpty()) break block2;
                if (null == objects || 0 >= objects.length) break block3;
                result = true;
                break block3;
            }
            if (null != objects) {
                for (Object object : objects) {
                    if (collection.contains(object)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public static <T> boolean distinct(Collection<T> collection) {
        HashSet<T> set = new HashSet<T>();
        for (T t : collection) {
            if (set.add(t)) continue;
            return false;
        }
        return true;
    }
}

