/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import java.util.function.Predicate;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.koryphe.ValidationResult;
import uk.gov.gchq.koryphe.tuple.n.Tuple3;

public final class FieldUtil {
    private FieldUtil() {
    }

    @SafeVarargs
    public static ValidationResult validateRequiredFields(Pair<String, Object> ... fields) {
        ValidationResult validationResult = new ValidationResult();
        for (Pair<String, Object> field : fields) {
            if (null != field.getSecond()) continue;
            validationResult.addError(field.getFirst() + " is required.");
        }
        return validationResult;
    }

    @SafeVarargs
    public static ValidationResult validateRequiredFields(Tuple3<String, Object, Predicate> ... fields) {
        ValidationResult validationResult = new ValidationResult();
        for (Tuple3<String, Object, Predicate> field : fields) {
            if (((Predicate)field.get2()).test(field.get1())) continue;
            validationResult.addError((String)field.get0());
        }
        return validationResult;
    }
}

