/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import java.nio.ByteBuffer;
import org.apache.hadoop.io.Text;

public final class TextUtil {
    private TextUtil() {
    }

    public static byte[] getBytes(Text text) {
        byte[] bytes = text.getBytes();
        if (bytes.length != text.getLength()) {
            bytes = new byte[text.getLength()];
            System.arraycopy(text.getBytes(), 0, bytes, 0, bytes.length);
        }
        return bytes;
    }

    public static ByteBuffer getByteBuffer(Text text) {
        if (text == null) {
            return null;
        }
        byte[] bytes = text.getBytes();
        return ByteBuffer.wrap(bytes, 0, text.getLength());
    }
}

