/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.elementvisibilityutil;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.io.WritableComparator;
import uk.gov.gchq.gaffer.commonutil.ByteBufferUtil;

public class ArrayByteSequence
implements Serializable,
Comparable<ArrayByteSequence> {
    private static final long serialVersionUID = 4850846929226802566L;
    protected byte[] data;
    protected int offset;
    protected int length;

    public ArrayByteSequence(byte[] data) {
        this.data = data;
        this.offset = 0;
        this.length = data.length;
    }

    public ArrayByteSequence(byte[] data, int offset, int length) {
        if (offset < 0 || offset > data.length || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(" Bad offset and/or length data.length = " + data.length + " offset = " + offset + " length = " + length);
        }
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public ArrayByteSequence(String s) {
        this(s.getBytes(StandardCharsets.UTF_8));
    }

    public ArrayByteSequence(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            this.data = buffer.array();
            this.offset = buffer.position() + buffer.arrayOffset();
            this.length = buffer.remaining();
        } else {
            this.offset = 0;
            this.data = ByteBufferUtil.toBytes(buffer);
            this.length = this.data.length;
        }
    }

    public byte byteAt(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("i < 0, " + i);
        }
        if (i >= this.length) {
            throw new IllegalArgumentException("i >= length, " + i + " >= " + this.length);
        }
        return this.data[this.offset + i];
    }

    public byte[] getBackingArray() {
        return this.data;
    }

    public boolean isBackedByArray() {
        return true;
    }

    public int length() {
        return this.length;
    }

    public int offset() {
        return this.offset;
    }

    public byte[] toArray() {
        if (this.offset == 0 && this.length == this.data.length) {
            return this.data;
        }
        byte[] copy = new byte[this.length];
        System.arraycopy(this.data, this.offset, copy, 0, this.length);
        return copy;
    }

    public String toString() {
        return new String(this.data, this.offset, this.length, StandardCharsets.UTF_8);
    }

    public ArrayByteSequence subSequence(int start, int end) {
        if (start > end || start < 0 || end > this.length) {
            throw new IllegalArgumentException("Bad start and/end start = " + start + " end=" + end + " offset=" + this.offset + " length=" + this.length);
        }
        return new ArrayByteSequence(this.data, this.offset + start, end - start);
    }

    public static int compareBytes(ArrayByteSequence bs1, ArrayByteSequence bs2) {
        int minLen = Math.min(bs1.length(), bs2.length());
        for (int i = 0; i < minLen; ++i) {
            int b;
            int a = bs1.byteAt(i) & 0xFF;
            if (a == (b = bs2.byteAt(i) & 0xFF)) continue;
            return a - b;
        }
        return bs1.length() - bs2.length();
    }

    @Override
    public int compareTo(ArrayByteSequence obs) {
        return this.isBackedByArray() && obs.isBackedByArray() ? WritableComparator.compareBytes((byte[])this.getBackingArray(), (int)this.offset(), (int)this.length(), (byte[])obs.getBackingArray(), (int)obs.offset(), (int)obs.length()) : ArrayByteSequence.compareBytes(this, obs);
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayByteSequence) {
            ArrayByteSequence obs = (ArrayByteSequence)o;
            return this == o ? true : (this.length() != obs.length() ? false : this.compareTo(obs) == 0);
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        if (this.isBackedByArray()) {
            byte[] i = this.getBackingArray();
            int end = this.offset() + this.length();
            for (int i1 = this.offset(); i1 < end; ++i1) {
                hash = 31 * hash + i[i1];
            }
        } else {
            for (int var5 = 0; var5 < this.length(); ++var5) {
                hash = 31 * hash + this.byteAt(var5);
            }
        }
        return hash;
    }
}

