/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.elementvisibilityutil;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.ArrayByteSequence;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.Authorisations;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.VisibilityEvaluator;

public class ElementVisibility {
    Node node = null;
    private byte[] expression;
    private static final Node EMPTY_NODE = new Node(NodeType.EMPTY, 0);

    public ElementVisibility(String expression) {
        this(expression.getBytes(StandardCharsets.UTF_8));
    }

    public ElementVisibility(byte[] expression) {
        this.validate(expression);
    }

    public byte[] getExpression() {
        return this.expression;
    }

    public static String quote(String term) {
        return new String(ElementVisibility.quote(term.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static byte[] quote(byte[] term) {
        boolean needsQuote = false;
        for (int i = 0; i < term.length; ++i) {
            if (Authorisations.isValidAuthChar(term[i])) continue;
            needsQuote = true;
            break;
        }
        if (!needsQuote) {
            return term;
        }
        return VisibilityEvaluator.escape(term, true);
    }

    public String toString() {
        return "[" + new String(this.expression, StandardCharsets.UTF_8) + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof ElementVisibility ? this.equals((ElementVisibility)obj) : false;
    }

    public boolean equals(ElementVisibility otherLe) {
        return Arrays.equals(this.expression, otherLe.expression);
    }

    public int hashCode() {
        return Arrays.hashCode(this.expression);
    }

    public Node getParseTree() {
        return this.node;
    }

    private void validate(byte[] expression) {
        if (expression != null && expression.length > 0) {
            ColumnVisibilityParser p = new ColumnVisibilityParser();
            this.node = p.parse(expression);
        } else {
            this.node = EMPTY_NODE;
        }
        this.expression = expression;
    }

    private static class ColumnVisibilityParser {
        private int index = 0;
        private int parens = 0;

        ColumnVisibilityParser() {
        }

        Node parse(byte[] expression) {
            if (expression.length > 0) {
                Node node = this.parse_(expression);
                if (node == null) {
                    throw new PatternSyntaxException("operator or missing parens", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                }
                if (this.parens != 0) {
                    throw new PatternSyntaxException("parenthesis mis-match", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                }
                return node;
            }
            return null;
        }

        Node processTerm(int start, int end, Node expr, byte[] expression) {
            if (start != end) {
                if (expr != null) {
                    throw new PatternSyntaxException("expression needs | or &", new String(expression, StandardCharsets.UTF_8), start);
                }
                return new Node(start, end);
            }
            if (expr == null) {
                throw new PatternSyntaxException("empty term", new String(expression, StandardCharsets.UTF_8), start);
            }
            return expr;
        }

        Node parse_(byte[] expression) {
            Node result = null;
            Node expr = null;
            int wholeTermStart = this.index;
            int subtermStart = this.index;
            boolean subtermComplete = false;
            block7: while (this.index < expression.length) {
                switch (expression[this.index++]) {
                    case 34: {
                        if (subtermStart != this.index - 1) {
                            throw new PatternSyntaxException("expression needs & or |", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                        }
                        while (this.index < expression.length && expression[this.index] != 34) {
                            if (expression[this.index] == 92) {
                                ++this.index;
                                if (expression[this.index] != 92 && expression[this.index] != 34) {
                                    throw new PatternSyntaxException("invalid escaping within quotes", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                                }
                            }
                            ++this.index;
                        }
                        if (this.index == expression.length) {
                            throw new PatternSyntaxException("unclosed quote", new String(expression, StandardCharsets.UTF_8), subtermStart);
                        }
                        if (subtermStart + 1 == this.index) {
                            throw new PatternSyntaxException("empty term", new String(expression, StandardCharsets.UTF_8), subtermStart);
                        }
                        ++this.index;
                        subtermComplete = true;
                        continue block7;
                    }
                    case 38: {
                        expr = this.processTerm(subtermStart, this.index - 1, expr, expression);
                        if (result != null) {
                            if (!result.type.equals((Object)NodeType.AND)) {
                                throw new PatternSyntaxException("cannot mix & and |", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                            }
                        } else {
                            result = new Node(NodeType.AND, wholeTermStart);
                        }
                        result.add(expr);
                        expr = null;
                        subtermStart = this.index;
                        subtermComplete = false;
                        continue block7;
                    }
                    case 40: {
                        ++this.parens;
                        if (subtermStart == this.index - 1 && expr == null) {
                            expr = this.parse_(expression);
                            subtermStart = this.index;
                            subtermComplete = false;
                            continue block7;
                        }
                        throw new PatternSyntaxException("expression needs & or |", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                    }
                    case 41: {
                        --this.parens;
                        Node child = this.processTerm(subtermStart, this.index - 1, expr, expression);
                        if (child == null && result == null) {
                            throw new PatternSyntaxException("empty expression not allowed", new String(expression, StandardCharsets.UTF_8), this.index);
                        }
                        if (result == null) {
                            return child;
                        }
                        if (result.type == child.type) {
                            for (Node c : child.children) {
                                result.add(c);
                            }
                        } else {
                            result.add(child);
                        }
                        result.end = this.index - 1;
                        return result;
                    }
                    case 124: {
                        expr = this.processTerm(subtermStart, this.index - 1, expr, expression);
                        if (result != null) {
                            if (!result.type.equals((Object)NodeType.OR)) {
                                throw new PatternSyntaxException("cannot mix | and &", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                            }
                        } else {
                            result = new Node(NodeType.OR, wholeTermStart);
                        }
                        result.add(expr);
                        expr = null;
                        subtermStart = this.index;
                        subtermComplete = false;
                        continue block7;
                    }
                }
                if (subtermComplete) {
                    throw new PatternSyntaxException("expression needs & or |", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                }
                byte var10 = expression[this.index - 1];
                if (Authorisations.isValidAuthChar(var10)) continue;
                throw new PatternSyntaxException("bad character (" + var10 + ")", new String(expression, StandardCharsets.UTF_8), this.index - 1);
            }
            Node child = this.processTerm(subtermStart, this.index, expr, expression);
            if (result != null) {
                result.add(child);
                result.end = this.index;
            } else {
                result = child;
            }
            if (result.type != NodeType.TERM && result.children.size() < 2) {
                throw new PatternSyntaxException("missing term", new String(expression, StandardCharsets.UTF_8), this.index);
            }
            return result;
        }
    }

    public static enum NodeType {
        EMPTY,
        TERM,
        OR,
        AND;

    }

    public static class Node {
        public static final List<Node> EMPTY = Collections.emptyList();
        NodeType type;
        int start;
        int end;
        List<Node> children = EMPTY;

        public Node(NodeType type, int start) {
            this.type = type;
            this.start = start;
            this.end = start + 1;
        }

        public Node(int start, int end) {
            this.type = NodeType.TERM;
            this.start = start;
            this.end = end;
        }

        public void add(Node child) {
            if (this.children == EMPTY) {
                this.children = new ArrayList<Node>();
            }
            this.children.add(child);
        }

        public NodeType getType() {
            return this.type;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public int getTermStart() {
            return this.start;
        }

        public int getTermEnd() {
            return this.end;
        }

        public ArrayByteSequence getTerm(byte[] expression) {
            if (this.type != NodeType.TERM) {
                throw new RuntimeException();
            }
            if (expression[this.start] == 34) {
                int qStart = this.start + 1;
                int qEnd = this.end - 1;
                return new ArrayByteSequence(expression, qStart, qEnd - qStart);
            }
            return new ArrayByteSequence(expression, this.start, this.end - this.start);
        }
    }
}

